/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtil {
    private static final String CLASSNAME;
    private static final Logger LOG;
    private static final ErrorHandler ERROR_HANDLER;
    private static boolean canReuseBuilders;
    private static final DocumentBuilderFactory BUILDER_FACTORY;
    private static final ThreadLocal<DocumentBuilder> REUSABLE_BUILDER;

    private XmlUtil() {
    }

    public static String getAttribute(Node node, String attr, String def) {
        NamedNodeMap attrs = node.getAttributes();
        Node val = attrs.getNamedItem(attr);
        if (val != null) {
            return val.getNodeValue();
        }
        return def;
    }

    public static String getAttribute(Node node, String attr) {
        return XmlUtil.getAttribute(node, attr, null);
    }

    public static Uri getUriAttribute(Node node, String attr, Uri def) {
        String uri = XmlUtil.getAttribute(node, attr);
        if (uri != null) {
            try {
                return Uri.parse(uri);
            }
            catch (IllegalArgumentException e) {
                return def;
            }
        }
        return def;
    }

    public static Uri getUriAttribute(Node node, String attr) {
        return XmlUtil.getUriAttribute(node, attr, null);
    }

    public static Uri getHttpUriAttribute(Node node, String attr, Uri base, Uri def) {
        Uri uri = XmlUtil.getUriAttribute(node, attr, def);
        if (uri == null) {
            return def;
        }
        if (base != null) {
            uri = base.resolve(uri);
        }
        if (!"http".equalsIgnoreCase(uri.getScheme()) && !"https".equalsIgnoreCase(uri.getScheme())) {
            return def;
        }
        return uri;
    }

    public static Uri getHttpUriAttribute(Node node, String attr, Uri base) {
        return XmlUtil.getHttpUriAttribute(node, attr, base, null);
    }

    public static boolean getBoolAttribute(Node node, String attr, boolean def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolAttribute(Node node, String attr) {
        return XmlUtil.getBoolAttribute(node, attr, false);
    }

    public static int getIntAttribute(Node node, String attr, int def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int getIntAttribute(Node node, String attr) {
        return XmlUtil.getIntAttribute(node, attr, 0);
    }

    private static DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilder builder;
        if (canReuseBuilders) {
            builder = REUSABLE_BUILDER.get();
            builder.reset();
        } else {
            builder = BUILDER_FACTORY.newDocumentBuilder();
        }
        builder.setErrorHandler(ERROR_HANDLER);
        return builder;
    }

    public static Element parse(String xml) throws XmlException {
        DocumentBuilder builder = null;
        try {
            builder = XmlUtil.getBuilder();
            InputSource is = new InputSource(new StringReader(xml.trim()));
            Element element = builder.parse(is).getDocumentElement();
            return element;
        }
        catch (SAXParseException e) {
            throw new XmlException(e.getMessage() + " At: (" + e.getLineNumber() + ',' + e.getColumnNumber() + ')', e);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        finally {
            if (builder != null) {
                builder.setErrorHandler(null);
            }
        }
    }

    public static Element parseSilent(String xml) {
        try {
            return XmlUtil.parse(xml);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            CLASSNAME = XmlUtil.class.getName();
                            LOG = Logger.getLogger(CLASSNAME, "org.apache.shindig.common.logging.i18n.resource");
                            ERROR_HANDLER = new ErrorHandler(){

                                public void error(SAXParseException exception) throws SAXException {
                                    throw exception;
                                }

                                public void fatalError(SAXParseException exception) throws SAXException {
                                    throw exception;
                                }

                                public void warning(SAXParseException exception) {
                                    if (LOG.isLoggable(Level.INFO)) {
                                        LOG.logp(Level.INFO, CLASSNAME, "warning", "commonErrorParsingXML", exception);
                                    }
                                }
                            };
                            canReuseBuilders = false;
                            BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
                            REUSABLE_BUILDER = new ThreadLocal<DocumentBuilder>(){

                                @Override
                                protected DocumentBuilder initialValue() {
                                    try {
                                        if (LOG.isLoggable(Level.FINE)) {
                                            LOG.fine("Created a new document builder");
                                        }
                                        return BUILDER_FACTORY.newDocumentBuilder();
                                    }
                                    catch (ParserConfigurationException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            };
                            BUILDER_FACTORY.setNamespaceAware(true);
                            BUILDER_FACTORY.setValidating(false);
                            try {
                                BUILDER_FACTORY.setAttribute("http://xml.org/sax/features/external-general-entities", false);
                            }
                            catch (IllegalArgumentException e) {
                                if (!LOG.isLoggable(Level.INFO)) break block13;
                                LOG.logp(Level.INFO, CLASSNAME, "static block", "errorParsingExternalGeneralEntities");
                            }
                        }
                        try {
                            BUILDER_FACTORY.setAttribute("http://xml.org/sax/features/external-parameter-entities", false);
                        }
                        catch (IllegalArgumentException e) {
                            if (!LOG.isLoggable(Level.INFO)) break block14;
                            LOG.logp(Level.INFO, CLASSNAME, "static block", "errorParsingExternalParameterEntities");
                        }
                    }
                    try {
                        BUILDER_FACTORY.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOG.isLoggable(Level.INFO)) break block15;
                        LOG.logp(Level.INFO, CLASSNAME, "static block", "errorParsingExternalDTD");
                    }
                }
                try {
                    BUILDER_FACTORY.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isLoggable(Level.INFO)) break block16;
                    LOG.logp(Level.INFO, CLASSNAME, "static block", "errorNotUsingSecureXML");
                }
            }
            try {
                DocumentBuilder builder = BUILDER_FACTORY.newDocumentBuilder();
                builder.reset();
                canReuseBuilders = true;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, CLASSNAME, "static block", "reuseDocumentBuilders");
                }
            }
            catch (UnsupportedOperationException e) {
                canReuseBuilders = false;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, CLASSNAME, "static block", "notReuseDocBuilders");
                }
            }
            catch (ParserConfigurationException e) {
                canReuseBuilders = false;
                if (!LOG.isLoggable(Level.INFO)) break block17;
                LOG.logp(Level.INFO, CLASSNAME, "static block", "notReuseDocBuilders");
            }
        }
    }
}

