/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.apache.shindig.config.ContainerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerConfigELResolver
extends ELResolver {
    public static final String CURRENT_CONFIG_KEY = "Cur";
    private final ContainerConfig config;
    private final String currentContainer;

    public ContainerConfigELResolver(ContainerConfig config, String currentContainer) {
        this.config = config;
        this.currentContainer = currentContainer;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null || base instanceof ContainerReference) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null || base instanceof ContainerReference) {
            context.setPropertyResolved(true);
            Object value = this.getValue(context, base, property);
            return value == null ? null : value.getClass();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        String container;
        if (base == null) {
            container = this.currentContainer;
        } else if (base instanceof ContainerReference) {
            container = ((ContainerReference)base).containerName;
        } else {
            return null;
        }
        context.setPropertyResolved(true);
        if ("parent".equals(property)) {
            String parent = this.config.getString(container, "parent");
            if (parent == null) {
                return null;
            }
            ContainerReference reference = new ContainerReference();
            reference.containerName = parent;
            return reference;
        }
        if (CURRENT_CONFIG_KEY.equals(property) && base == null) {
            ContainerReference reference = new ContainerReference();
            reference.containerName = this.currentContainer;
            return reference;
        }
        return this.config.getProperty(container, property.toString());
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null || base instanceof ContainerReference) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null || base instanceof ContainerReference) {
            throw new PropertyNotWritableException();
        }
    }

    private static class ContainerReference {
        public String containerName;

        private ContainerReference() {
        }
    }
}

