/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.apache.shindig.config.BasicContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigELResolver;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.config.DynamicConfigProperty;
import org.apache.shindig.expressions.Expressions;

@Singleton
public class ExpressionContainerConfig
extends BasicContainerConfig {
    protected Map<String, Map<String, Object>> rawConfig;
    private final Expressions expressions;

    public ExpressionContainerConfig(Expressions expressions) {
        this.expressions = expressions;
        this.rawConfig = Maps.newHashMap();
    }

    public ContainerConfig.Transaction newTransaction() {
        return new ExpressionTransaction();
    }

    public Object getProperty(String container, String property) {
        if (property.startsWith("${")) {
            try {
                ValueExpression expression = this.expressions.parse(property, Object.class);
                return expression.getValue(this.createExpressionContext(container));
            }
            catch (ELException e) {
                return null;
            }
        }
        return super.getProperty(container, property);
    }

    protected Expressions getExpressions() {
        return this.expressions;
    }

    protected ELContext createExpressionContext(String container) {
        return this.getExpressions().newELContext(new ContainerConfigELResolver(this, container));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExpressionTransaction
    extends BasicContainerConfig.BasicTransaction {
        @Override
        protected BasicContainerConfig getTemporaryConfig(boolean copyValues) {
            ExpressionContainerConfig tmp = new ExpressionContainerConfig(ExpressionContainerConfig.this.getExpressions());
            if (copyValues) {
                tmp.rawConfig = this.deepCopyConfig(ExpressionContainerConfig.this.rawConfig);
                tmp.config = this.deepCopyConfig(ExpressionContainerConfig.this.config);
            }
            return tmp;
        }

        @Override
        protected void changeContainersInConfig(BasicContainerConfig config, Map<String, Map<String, Object>> setContainers, Set<String> removeContainers) throws ContainerConfigException {
            ExpressionContainerConfig tmp = (ExpressionContainerConfig)config;
            tmp.rawConfig.putAll(setContainers);
            for (String container : removeContainers) {
                tmp.rawConfig.remove(container);
            }
            tmp.config.clear();
            for (String container : tmp.rawConfig.keySet()) {
                Map<String, Object> merged = this.mergeParents(container, tmp.rawConfig);
                tmp.rawConfig.put(container, merged);
                Map value = (Map)this.parseAll(merged, tmp.createExpressionContext(container));
                tmp.config.put(container, value);
            }
            for (String container : tmp.config.keySet()) {
                Map value = (Map)this.evaluateAll(tmp.config.get(container));
                tmp.config.put(container, value);
            }
        }

        @Override
        protected void setNewConfig(BasicContainerConfig newConfig) {
            ExpressionContainerConfig tmp = (ExpressionContainerConfig)newConfig;
            ExpressionContainerConfig.this.rawConfig = tmp.rawConfig;
            ExpressionContainerConfig.this.config = tmp.config;
        }

        private Object parseAll(Object value, ELContext context) {
            if (value instanceof String) {
                return new DynamicConfigProperty((String)value, ExpressionContainerConfig.this.expressions, context);
            }
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                HashMap newMap = Maps.newHashMap();
                for (Map.Entry entry : mapValue.entrySet()) {
                    newMap.put(entry.getKey(), this.parseAll(entry.getValue(), context));
                }
                return Collections.unmodifiableMap(newMap);
            }
            if (value instanceof List) {
                ArrayList newList = Lists.newArrayList();
                for (Object entry : (List)value) {
                    newList.add(this.parseAll(entry, context));
                }
                return Collections.unmodifiableList(newList);
            }
            return value;
        }

        private Object evaluateAll(Object value) {
            if (value instanceof CharSequence) {
                return value.toString();
            }
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                HashMap newMap = Maps.newHashMap();
                for (Map.Entry entry : mapValue.entrySet()) {
                    newMap.put(entry.getKey(), this.evaluateAll(entry.getValue()));
                }
                return Collections.unmodifiableMap(newMap);
            }
            if (value instanceof List) {
                ArrayList newList = Lists.newArrayList();
                for (Object entry : (List)value) {
                    newList.add(this.evaluateAll(entry));
                }
                return Collections.unmodifiableList(newList);
            }
            return value;
        }
    }
}

