/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentTypes {
    public static final Set<String> ALLOWED_JSON_CONTENT_TYPES = ImmutableSet.of((Object)"application/json", (Object)"text/x-json", (Object)"application/javascript", (Object)"application/x-javascript", (Object)"text/javascript", (Object)"text/ecmascript", (Object[])new String[]{"application/json-rpc", "application/jsonrequest"});
    public static final Set<String> ALLOWED_XML_CONTENT_TYPES = ImmutableSet.of((Object)"text/xml", (Object)"application/xml");
    public static final Set<String> ALLOWED_ATOM_CONTENT_TYPES = ImmutableSet.of((Object)"application/atom+xml");
    public static final Set<String> FORBIDDEN_CONTENT_TYPES = ImmutableSet.of((Object)"application/x-www-form-urlencoded");
    public static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    public static final Set<String> ALLOWED_MULTIPART_CONTENT_TYPES = ImmutableSet.of((Object)"multipart/form-data");
    public static final String OUTPUT_JSON_CONTENT_TYPE = "application/json";
    public static final String OUTPUT_XML_CONTENT_TYPE = "application/xml";
    public static final String OUTPUT_ATOM_CONTENT_TYPE = "application/atom+xml";

    private ContentTypes() {
    }

    public static String extractMimePart(String contentType) {
        int separator = (contentType = contentType.trim()).indexOf(59);
        if (separator != -1) {
            contentType = contentType.substring(0, separator);
        }
        return contentType.trim().toLowerCase();
    }

    public static void checkContentTypes(Set<String> allowedContentTypes, String contentType) throws InvalidContentTypeException {
        if (Strings.isNullOrEmpty((String)contentType)) {
            throw new InvalidContentTypeException("No Content-Type specified. One of " + Joiner.on((String)", ").join(allowedContentTypes) + " is required");
        }
        if (FORBIDDEN_CONTENT_TYPES.contains(contentType = ContentTypes.extractMimePart(contentType))) {
            throw new InvalidContentTypeException("Cannot use disallowed Content-Type " + contentType);
        }
        if (allowedContentTypes.contains(contentType)) {
            return;
        }
        throw new InvalidContentTypeException("Unsupported Content-Type " + contentType + ". One of " + Joiner.on((String)", ").join(allowedContentTypes) + " is required");
    }

    public static class InvalidContentTypeException
    extends Exception {
        public InvalidContentTypeException(String message) {
            super(message);
        }
    }
}

