/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.protocol.ApiServlet;
import org.apache.shindig.protocol.ContentTypes;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ResponseItem;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;

public class DataServiceServlet
extends ApiServlet {
    private static final Logger LOG = Logger.getLogger(DataServiceServlet.class.getName());
    public static final Set<String> ALLOWED_CONTENT_TYPES = new ImmutableSet.Builder().addAll(ContentTypes.ALLOWED_JSON_CONTENT_TYPES).addAll(ContentTypes.ALLOWED_XML_CONTENT_TYPES).addAll(ContentTypes.ALLOWED_ATOM_CONTENT_TYPES).build();
    protected static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.executeRequest(servletRequest, servletResponse);
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        try {
            ContentTypes.checkContentTypes(ALLOWED_CONTENT_TYPES, servletRequest.getContentType());
            this.executeRequest(servletRequest, servletResponse);
        }
        catch (ContentTypes.InvalidContentTypeException icte) {
            this.sendError(servletResponse, new ResponseItem(400, icte.getMessage()));
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.executeRequest(servletRequest, servletResponse);
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        try {
            ContentTypes.checkContentTypes(ALLOWED_CONTENT_TYPES, servletRequest.getContentType());
            this.executeRequest(servletRequest, servletResponse);
        }
        catch (ContentTypes.InvalidContentTypeException icte) {
            this.sendError(servletResponse, new ResponseItem(400, icte.getMessage()));
        }
    }

    void executeRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Handling restful request for " + servletRequest.getPathInfo());
        }
        this.setCharacterEncodings(servletRequest, servletResponse);
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        HttpUtil.setCORSheader(servletResponse, this.containerConfig.getList(token.getContainer(), "gadgets.parentOrigins"));
        this.handleSingleRequest(servletRequest, servletResponse, token);
    }

    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        String errorMessage = responseItem.getErrorMessage();
        int errorCode = responseItem.getErrorCode();
        if (errorCode < 0) {
            switch (errorCode) {
                case -32700: 
                case -32602: 
                case -32600: {
                    errorCode = 400;
                    break;
                }
                case -32601: {
                    errorCode = 501;
                    break;
                }
                default: {
                    errorCode = 500;
                }
            }
        }
        servletResponse.sendError(errorCode, errorMessage);
    }

    private void handleSingleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token) throws IOException {
        String contentType;
        String format;
        RestHandler handler;
        block11: {
            block10: {
                handler = this.getRestHandler(servletRequest);
                format = null;
                contentType = null;
                try {
                    format = servletRequest.getParameter("format");
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINE)) break block10;
                    LOG.fine("Unexpected error : format param is null " + t.toString());
                }
            }
            try {
                contentType = ContentTypes.extractMimePart(servletRequest.getContentType());
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) break block11;
                LOG.fine("Unexpected error : content type is null " + t.toString());
            }
        }
        BeanConverter requestConverter = this.getConverterForRequest(contentType, format);
        BeanConverter responseConverter = this.getConverterForFormat(format);
        BufferedReader bodyReader = null;
        if (!servletRequest.getMethod().equals("GET") && !servletRequest.getMethod().equals("HEAD")) {
            bodyReader = servletRequest.getReader();
        }
        Map parameterMap = servletRequest.getParameterMap();
        Future<?> future = handler.execute(parameterMap, bodyReader, token, requestConverter);
        ResponseItem responseItem = this.getResponseItem(future);
        servletResponse.setContentType(responseConverter.getContentType());
        if (responseItem.getErrorCode() >= 200 && responseItem.getErrorCode() < 400) {
            String callback;
            PrintWriter writer = servletResponse.getWriter();
            Object response = responseItem.getResponse();
            if (!(response instanceof DataCollection) && !(response instanceof RestfulCollection)) {
                response = ImmutableMap.of((Object)"entry", (Object)response);
            }
            String string = callback = this.isJSONPAllowed != false && HttpUtil.isJSONP(servletRequest) && "application/json".equals(responseConverter.getContentType()) ? servletRequest.getParameter("callback") : null;
            if (callback != null) {
                writer.write(callback + '(');
            }
            writer.write(responseConverter.convertToString(response));
            if (callback != null) {
                writer.write(");\n");
            }
        } else {
            this.sendError(servletResponse, responseItem);
        }
    }

    protected RestHandler getRestHandler(HttpServletRequest servletRequest) {
        String path = servletRequest.getPathInfo();
        String method = servletRequest.getParameter(X_HTTP_METHOD_OVERRIDE);
        if (method == null) {
            method = servletRequest.getMethod();
        }
        return this.dispatcher.getRestHandler(path, method.toUpperCase());
    }

    public BeanConverter getConverterForRequest(@Nullable String contentType, String format) {
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            return this.getConverterForContentType(contentType);
        }
        return this.getConverterForFormat(format);
    }

    protected BeanConverter getConverterForContentType(String contentType) {
        return ContentTypes.ALLOWED_ATOM_CONTENT_TYPES.contains(contentType) ? this.atomConverter : (ContentTypes.ALLOWED_XML_CONTENT_TYPES.contains(contentType) ? this.xmlConverter : this.jsonConverter);
    }

    protected BeanConverter getConverterForFormat(String format) {
        return "atom".equals(format) ? this.atomConverter : ("xml".equals(format) ? this.xmlConverter : this.jsonConverter);
    }
}

