/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulCollection<T>
extends HashMap<String, Object> {
    private List<T> list;
    private int startIndex;
    private int totalResults;
    private int itemsPerPage;
    private boolean filtered = false;
    private boolean sorted = false;
    private boolean updatedSince = false;

    public RestfulCollection(List<T> entry) {
        this(entry, 0, entry.size(), entry.size());
        this.filtered = true;
        this.sorted = true;
        this.updatedSince = true;
        this.put("filtered", true);
        this.put("sorted", true);
        this.put("updatedSince", true);
    }

    public RestfulCollection(List<T> list, int startIndex, int totalResults, int itemsPerPage) {
        this.list = list;
        this.startIndex = startIndex;
        this.totalResults = totalResults;
        this.itemsPerPage = Math.min(itemsPerPage, totalResults);
        this.put("list", list);
        this.put("startIndex", startIndex);
        this.put("totalResults", totalResults);
        this.put("itemsPerPage", this.itemsPerPage);
    }

    public RestfulCollection(List<T> entry, int startIndex, int totalResults) {
        this(entry, startIndex, totalResults, entry.size());
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
        this.put("list", list);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        this.put("startIndex", startIndex);
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        this.put("itemsPerPage", itemsPerPage);
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setTotalResults(int totalResults) {
        this.totalResults = totalResults;
        this.put("totalResults", totalResults);
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
        this.put("filtered", filtered);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
        this.put("sorted", sorted);
    }

    public boolean isUpdatedSince() {
        return this.updatedSince;
    }

    public void setUpdatedSince(boolean updatedSince) {
        this.updatedSince = updatedSince;
        this.put("updatedSince", updatedSince);
    }
}

