/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.uri.Uri;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDelegator {
    public static final String NULL = "<NULL sentinel>";
    public static final ImmutableSet<Class<?>> PRIMITIVE_TYPE_CLASSES = ImmutableSet.of(String.class, Integer.class, Long.class, Boolean.class, Uri.class);
    private final Map<Class<?>, Class<?>> delegatedClasses;
    private final Map<Enum<?>, Enum<?>> enumConvertionMap;

    public static Object nullable(Object o) {
        return o != null ? o : NULL;
    }

    public static String normalizeName(String name) {
        return StringUtils.remove((String)name, (char)'_').toLowerCase();
    }

    public static Map<String, Object> normalizeFields(Map<String, Object> original) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (original != null) {
            for (Map.Entry<String, Object> entry : original.entrySet()) {
                builder.put((Object)BeanDelegator.normalizeName(entry.getKey()), BeanDelegator.nullable(entry.getValue()));
            }
        }
        return builder.build();
    }

    public BeanDelegator() {
        this((Map<Class<?>, Class<?>>)ImmutableMap.of(), (Map<Enum<?>, Enum<?>>)ImmutableMap.of());
    }

    public BeanDelegator(Map<Class<?>, Class<?>> delegatedClasses, Map<Enum<?>, Enum<?>> enumConvertionMap) {
        this.delegatedClasses = delegatedClasses;
        this.enumConvertionMap = enumConvertionMap;
    }

    public Object createDelegator(Object source) {
        if (source == null || this.delegatedClasses == null) {
            return source;
        }
        if (this.delegatedClasses.containsKey(source.getClass())) {
            Class<?> apiInterface = this.delegatedClasses.get(source.getClass());
            return this.createDelegator(source, apiInterface);
        }
        return source;
    }

    public <T> T createDelegator(Object source, Class<T> apiInterface) {
        return this.createDelegator(source, apiInterface, null);
    }

    public <T> T createDelegator(Object source, Class<T> apiInterface, Map<String, Object> extraFields) {
        extraFields = BeanDelegator.normalizeFields(extraFields);
        if (source == null && !extraFields.isEmpty()) {
            source = new NullClass();
        }
        if (source == null) {
            return null;
        }
        if (apiInterface.isPrimitive() || apiInterface.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        if (source instanceof Enum && this.delegatedClasses.containsKey(source.getClass())) {
            return (T)this.convertEnum((Enum)source);
        }
        if (source instanceof Map) {
            Map mapSource = (Map)source;
            if (!mapSource.isEmpty() && this.delegatedClasses.containsKey(mapSource.values().iterator().next().getClass())) {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                for (Map.Entry entry : mapSource.entrySet()) {
                    mapBuilder.put(entry.getKey(), this.createDelegator(entry.getValue(), apiInterface));
                }
                return (T)mapBuilder.build();
            }
            return (T)source;
        }
        if (source instanceof Multimap) {
            Multimap mapSource = (Multimap)source;
            if (!mapSource.isEmpty() && this.delegatedClasses.containsKey(mapSource.values().iterator().next().getClass())) {
                ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
                for (Map.Entry entry : mapSource.entries()) {
                    mapBuilder.put(entry.getKey(), this.createDelegator(entry.getValue(), apiInterface));
                }
                return (T)mapBuilder.build();
            }
            return (T)source;
        }
        if (source instanceof List) {
            List listSource = (List)source;
            if (!listSource.isEmpty() && this.delegatedClasses.containsKey(listSource.get(0).getClass())) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                for (Object entry : listSource) {
                    listBuilder.add(this.createDelegator(entry, apiInterface));
                }
                return (T)listBuilder.build();
            }
            return (T)source;
        }
        return (T)Proxy.newProxyInstance(apiInterface.getClassLoader(), new Class[]{apiInterface}, (InvocationHandler)new DelegateInvocationHandler(source, extraFields));
    }

    public Enum<?> convertEnum(Enum<?> value) {
        if (this.enumConvertionMap.containsKey(value)) {
            return this.enumConvertionMap.get(value);
        }
        throw new UnsupportedOperationException("Unknown enum value " + value.name());
    }

    private Class<?> getParameterizedReturnType(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (List.class.isAssignableFrom((Class)paramType.getRawType())) {
                type = paramType.getActualTypeArguments()[0];
            } else if (Map.class.isAssignableFrom((Class)paramType.getRawType())) {
                type = paramType.getActualTypeArguments()[1];
            } else if (Multimap.class.isAssignableFrom((Class)paramType.getRawType())) {
                type = paramType.getActualTypeArguments()[1];
            }
        }
        return (Class)type;
    }

    public void validate() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        for (Map.Entry<Class<?>, Class<?>> entry : this.delegatedClasses.entrySet()) {
            if (entry.getKey().isEnum()) continue;
            this.validate(entry.getKey(), entry.getValue());
        }
    }

    public void validate(Class<?> dataClass, Class<?> interfaceClass) throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        for (Method method : interfaceClass.getMethods()) {
            Method dataMethod = dataClass.getMethod(method.getName(), method.getParameterTypes());
            if (dataMethod == null) {
                throw new NoSuchMethodException("Method " + method.getName() + " is not implemented by " + dataClass.getName());
            }
            if (this.validateTypes(dataMethod.getGenericReturnType(), method.getGenericReturnType())) continue;
            throw new NoSuchMethodException("Method " + method.getName() + " has wrong return type by " + dataClass.getName());
        }
    }

    private boolean validateTypes(Type dataType, Type interfaceType) throws NoSuchFieldException {
        if (dataType instanceof ParameterizedType) {
            ParameterizedType dataParamType = (ParameterizedType)dataType;
            ParameterizedType interfaceParamType = (ParameterizedType)interfaceType;
            if (List.class.isAssignableFrom((Class)dataParamType.getRawType()) && List.class.isAssignableFrom((Class)interfaceParamType.getRawType())) {
                dataType = dataParamType.getActualTypeArguments()[0];
                interfaceType = interfaceParamType.getActualTypeArguments()[0];
                return this.validateTypes(dataType, interfaceType);
            }
            if (Map.class.isAssignableFrom((Class)dataParamType.getRawType()) && Map.class.isAssignableFrom((Class)interfaceParamType.getRawType())) {
                Type interfaceKeyType;
                Type dataKeyType = dataParamType.getActualTypeArguments()[0];
                if (dataKeyType != (interfaceKeyType = interfaceParamType.getActualTypeArguments()[0]) || !PRIMITIVE_TYPE_CLASSES.contains((Object)dataKeyType)) {
                    return false;
                }
                dataType = dataParamType.getActualTypeArguments()[1];
                interfaceType = interfaceParamType.getActualTypeArguments()[1];
                return this.validateTypes(dataType, interfaceType);
            }
            if (Multimap.class.isAssignableFrom((Class)dataParamType.getRawType()) && Multimap.class.isAssignableFrom((Class)interfaceParamType.getRawType())) {
                Type interfaceKeyType;
                Type dataKeyType = dataParamType.getActualTypeArguments()[0];
                if (dataKeyType != (interfaceKeyType = interfaceParamType.getActualTypeArguments()[0]) || !PRIMITIVE_TYPE_CLASSES.contains((Object)dataKeyType)) {
                    return false;
                }
                dataType = dataParamType.getActualTypeArguments()[1];
                interfaceType = interfaceParamType.getActualTypeArguments()[1];
                return this.validateTypes(dataType, interfaceType);
            }
            return false;
        }
        if (dataType == interfaceType) {
            return PRIMITIVE_TYPE_CLASSES.contains((Object)dataType) || ((Class)dataType).isPrimitive();
        }
        Class dataClass = (Class)dataType;
        if (dataClass.isEnum()) {
            for (Object f : dataClass.getEnumConstants()) {
                if (this.enumConvertionMap.containsKey(f) && this.enumConvertionMap.get(f).getClass() == interfaceType) continue;
                throw new NoSuchFieldException("Enum " + dataClass.getName() + " don't have mapping for value " + f.toString());
            }
        }
        return this.delegatedClasses.get(dataType) == interfaceType;
    }

    public static void validateDelegator(Object o) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Method method : o.getClass().getInterfaces()[0].getMethods()) {
            if (!method.getName().startsWith("get")) continue;
            Object val = method.invoke(o, new Object[0]);
        }
    }

    public static Map<Enum<?>, Enum<?>> createDefaultEnumMap(Class<? extends Enum<?>> sourceEnum, Class<? extends Enum<?>> targetEnum) {
        HashMap values2Map = Maps.newHashMap();
        for (Enum<?> val2 : targetEnum.getEnumConstants()) {
            values2Map.put(val2.name(), val2);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Enum<?> val1 : sourceEnum.getEnumConstants()) {
            if (!values2Map.containsKey(val1.name())) {
                throw new RuntimeException("Missing enum value " + val1.name() + " for enum " + targetEnum.getName());
            }
            mapBuilder.put(val1, values2Map.get(val1.name()));
        }
        return mapBuilder.build();
    }

    public static class NullClass {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DelegateInvocationHandler
    implements InvocationHandler {
        private final Object source;
        private final Map<String, Object> extraFields;

        public DelegateInvocationHandler(Object source) {
            this(source, null);
        }

        public DelegateInvocationHandler(Object source, Map<String, Object> extraFields) {
            Preconditions.checkNotNull((Object)source);
            this.source = source;
            this.extraFields = extraFields;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Exception exc;
            String field;
            Class<?> sourceClass = this.source.getClass();
            if (!this.extraFields.isEmpty() && method.getName().startsWith("get") && this.extraFields.containsKey(field = method.getName().substring(3).toLowerCase())) {
                Object data = this.extraFields.get(field);
                return data == BeanDelegator.NULL ? null : data;
            }
            try {
                Method sourceMethod = sourceClass.getMethod(method.getName(), method.getParameterTypes());
                Object result = sourceMethod.invoke(this.source, args);
                return BeanDelegator.this.createDelegator(result, BeanDelegator.this.getParameterizedReturnType(method));
            }
            catch (NoSuchMethodException e) {
                exc = e;
            }
            catch (IllegalArgumentException e) {
                exc = e;
            }
            catch (IllegalAccessException e) {
                exc = e;
            }
            catch (InvocationTargetException e) {
                exc = e;
            }
            throw new UnsupportedOperationException("Unsupported function: " + method.getName(), exc);
        }
    }
}

