/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.protocol.conversion.BeanDelegator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFilter {
    public static final String ALL_FIELDS = "*";
    public static final String DELIMITER = ".";

    public Object createFilteredBean(Object data, Set<String> fields) {
        return this.createFilteredBean(data, fields, "");
    }

    private Object createFilteredBean(Object data, Set<String> fields, String fieldName) {
        if (data == null || fields == null || BeanDelegator.PRIMITIVE_TYPE_CLASSES.contains(data.getClass()) || fields.contains(ALL_FIELDS)) {
            return data;
        }
        if (data instanceof Map) {
            Map oldMap = (Map)data;
            HashMap newMap = Maps.newHashMapWithExpectedSize((int)oldMap.size());
            for (Map.Entry entry : oldMap.entrySet()) {
                newMap.put(entry.getKey(), this.createFilteredBean(entry.getValue(), fields, fieldName));
            }
            return newMap;
        }
        if (data instanceof List) {
            List oldList = (List)data;
            ArrayList newList = Lists.newArrayListWithCapacity((int)oldList.size());
            for (Object entry : oldList) {
                newList.add(this.createFilteredBean(entry, fields, fieldName));
            }
            return newList;
        }
        return Proxy.newProxyInstance(data.getClass().getClassLoader(), data.getClass().getInterfaces(), (InvocationHandler)new FilterInvocationHandler(data, fields, fieldName));
    }

    public Set<String> processBeanFields(Collection<String> fields) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String field : fields) {
            builder.add((Object)field.toLowerCase());
            while (field.contains(DELIMITER)) {
                field = field.substring(0, field.lastIndexOf(DELIMITER));
                builder.add((Object)field.toLowerCase());
            }
        }
        return builder.build();
    }

    public List<String> getBeanFields(Class<?> bean, int depth) {
        LinkedList fields = Lists.newLinkedList();
        for (Method method : bean.getMethods()) {
            Type[] parameterArgTypes;
            ParameterizedType aType;
            if (!method.getName().startsWith("get")) continue;
            String fieldName = method.getName().substring(3);
            fields.add(fieldName);
            Class returnType = method.getReturnType();
            if (List.class.isAssignableFrom(returnType)) {
                aType = (ParameterizedType)method.getGenericReturnType();
                parameterArgTypes = aType.getActualTypeArguments();
                returnType = parameterArgTypes.length > 0 ? (Class)parameterArgTypes[0] : null;
            }
            if (Map.class.isAssignableFrom(returnType)) {
                aType = (ParameterizedType)method.getGenericReturnType();
                parameterArgTypes = aType.getActualTypeArguments();
                returnType = parameterArgTypes.length > 1 ? (Class)parameterArgTypes[1] : null;
            }
            if (depth <= 1 || returnType == null || returnType.isPrimitive() || returnType.isEnum() || BeanDelegator.PRIMITIVE_TYPE_CLASSES.contains((Object)returnType)) continue;
            List<String> subFields = this.getBeanFields(returnType, depth - 1);
            for (String field : subFields) {
                fields.add(fieldName + DELIMITER + field);
            }
        }
        return fields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterInvocationHandler
    implements InvocationHandler {
        private final String prefix;
        private final Set<String> fields;
        private final Object origData;

        FilterInvocationHandler(Object origData, Set<String> fields, String fieldName) {
            this.fields = fields;
            this.prefix = Strings.isNullOrEmpty((String)fieldName) ? "" : fieldName + BeanFilter.DELIMITER;
            this.origData = origData;
        }

        @Override
        public Object invoke(Object data, Method method, Object[] args) {
            Object result;
            String fieldName = null;
            if (method.getName().startsWith("get") && !method.getReturnType().isPrimitive()) {
                boolean required = method.getAnnotation(Unfiltered.class) != null;
                fieldName = this.prefix + method.getName().substring(3).toLowerCase();
                if (!required && !this.fields.contains(fieldName)) {
                    return null;
                }
            }
            try {
                result = method.invoke(this.origData, args);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (result != null && fieldName != null && !this.fields.contains(fieldName + BeanFilter.DELIMITER + BeanFilter.ALL_FIELDS)) {
                return BeanFilter.this.createFilteredBean(result, this.fields, fieldName);
            }
            return result;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Unfiltered {
    }
}

