/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceBeanProvider {
    protected static final Object[] NO_PARAMS = new Object[0];
    private final Comparator<String> propertyNameComparator;
    private final transient LoadingCache<Class<?>, Map<String, PropertyDescriptor>> propertyNameCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Map<String, PropertyDescriptor>>(){

        public Map<String, PropertyDescriptor> load(Class<?> type) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(type, Object.class);
            }
            catch (IntrospectionException e) {
                throw new ObjectAccessException("Cannot get BeanInfo of type " + type.getName(), (Throwable)e);
            }
            ImmutableMap.Builder nameMapBuilder = ImmutableMap.builder();
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                nameMapBuilder.put((Object)descriptor.getName(), (Object)descriptor);
            }
            return nameMapBuilder.build();
        }
    });
    private Injector injector;

    public GuiceBeanProvider(Injector injector) {
        this(injector, null);
    }

    public GuiceBeanProvider(Injector injector, Comparator<String> propertyNameComparator) {
        this.propertyNameComparator = propertyNameComparator;
        this.injector = injector;
    }

    public Object newInstance(Class<?> type) {
        return this.injector.getInstance(type);
    }

    public void visitSerializableProperties(Object object, Visitor visitor) {
        for (PropertyDescriptor property : this.getSerializableProperties(object)) {
            try {
                Class<?> definedIn;
                Method readMethod = property.getReadMethod();
                String name = property.getName();
                if (!visitor.shouldVisit(name, definedIn = readMethod.getDeclaringClass())) continue;
                Object value = readMethod.invoke(object, new Object[0]);
                visitor.visit(name, property.getPropertyType(), definedIn, value);
            }
            catch (IllegalArgumentException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + '.' + property.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + '.' + property.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + '.' + property.getName(), (Throwable)e);
            }
        }
    }

    public void writeProperty(Object object, String propertyName, Object value) {
        PropertyDescriptor property = this.getProperty(propertyName, object.getClass());
        try {
            property.getWriteMethod().invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + '.' + property.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + '.' + property.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + '.' + property.getName(), (Throwable)e);
        }
    }

    public Class<?> getPropertyType(Object object, String name) {
        return this.getProperty(name, object.getClass()).getPropertyType();
    }

    public boolean propertyDefinedInClass(String name, Class<?> type) {
        return this.getProperty(name, type) != null;
    }

    private List<PropertyDescriptor> getSerializableProperties(Object object) {
        Map nameMap = (Map)this.propertyNameCache.getUnchecked(object.getClass());
        ImmutableSortedSet names = this.propertyNameComparator == null ? nameMap.keySet() : ImmutableSortedSet.orderedBy(this.propertyNameComparator).addAll(nameMap.keySet()).build();
        ArrayList result = Lists.newArrayListWithCapacity((int)nameMap.size());
        for (String name : names) {
            PropertyDescriptor descriptor = (PropertyDescriptor)nameMap.get(name);
            if (!this.canStreamProperty(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }

    protected boolean canStreamProperty(PropertyDescriptor descriptor) {
        return descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null;
    }

    public boolean propertyWriteable(String name, Class<?> type) {
        PropertyDescriptor property = this.getProperty(name, type);
        return property.getWriteMethod() != null;
    }

    private PropertyDescriptor getProperty(String name, Class<?> type) {
        return (PropertyDescriptor)((Map)this.propertyNameCache.getUnchecked(type)).get(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Visitor {
        public boolean shouldVisit(String var1, Class<?> var2);

        public void visit(String var1, Class<?> var2, Class<?> var3, Object var4);
    }
}

