/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Iterator;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.config.ExpressionContainerConfig;
import org.apache.shindig.config.JsonContainerConfigLoader;
import org.apache.shindig.expressions.Expressions;
import org.json.JSONObject;

@Singleton
public class JsonContainerConfig
extends ExpressionContainerConfig {
    public JsonContainerConfig(String containers, Expressions expressions) throws ContainerConfigException {
        this(containers, "localhost", "8080", "", expressions);
    }

    @Inject
    public JsonContainerConfig(@Named(value="shindig.containers.default") String containers, @Nullable @Named(value="shindig.host") String host, @Nullable @Named(value="shindig.port") String port, @Nullable @Named(value="shindig.contextroot") String contextRoot, Expressions expressions) throws ContainerConfigException {
        super(expressions);
        JsonContainerConfigLoader.getTransactionFromFile(containers, host, port, contextRoot, this).commit();
    }

    public JsonContainerConfig(JSONObject json, Expressions expressions) throws ContainerConfigException {
        super(expressions);
        ContainerConfig.Transaction transaction = this.newTransaction();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            JSONObject optJSONObject = json.optJSONObject((String)keys.next());
            if (optJSONObject == null) continue;
            transaction.addContainer(JsonContainerConfigLoader.parseJsonContainer(optJSONObject));
        }
        transaction.commit();
    }
}

