/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthInfoUtil;
import org.apache.shindig.auth.SecurityToken;

public class AuthInfo {
    private final HttpServletRequest req;

    @Inject
    public AuthInfo(HttpServletRequest req) {
        this.req = req;
    }

    public SecurityToken getSecurityToken() {
        return AuthInfoUtil.getSecurityTokenFromRequest(this.req);
    }

    public String getAuthType() {
        return AuthInfoUtil.getAuthTypeFromRequest(this.req);
    }

    public static class Attribute {
        public static final AuthInfoUtil.Attribute SECURITY_TOKEN = AuthInfoUtil.Attribute.SECURITY_TOKEN;
        public static final AuthInfoUtil.Attribute AUTH_TYPE = AuthInfoUtil.Attribute.AUTH_TYPE;
    }
}

