/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;

public class GuiceServletContextListener
implements ServletContextListener {
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";
    public static final String MODULES_ATTRIBUTE = "guice-modules";
    public static final String INJECTOR_NAME = Injector.class.getName();
    private static final String SYSTEM_PROPERTIES = "system.properties";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        this.setSystemProperties(context);
        String moduleNames = context.getInitParameter(MODULES_ATTRIBUTE);
        LinkedList modules = Lists.newLinkedList();
        if (moduleNames != null) {
            for (String moduleName : Splitter.on((char)':').split((CharSequence)moduleNames)) {
                try {
                    if ((moduleName = moduleName.trim()).length() <= 0) continue;
                    try {
                        modules.add((Module)Class.forName(moduleName).newInstance());
                    }
                    catch (Throwable t) {
                        modules.add((Module)Thread.currentThread().getContextClassLoader().loadClass(moduleName).newInstance());
                    }
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules);
        context.setAttribute(INJECTOR_ATTRIBUTE, (Object)injector);
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        Injector injector = (Injector)context.getAttribute(INJECTOR_ATTRIBUTE);
        if (injector != null) {
            CleanupHandler cleanups = (CleanupHandler)injector.getInstance(CleanupHandler.class);
            cleanups.cleanup();
        }
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }

    private void setSystemProperties(ServletContext context) {
        String contextRoot = context.getContextPath();
        System.setProperty("shindig.contextroot", contextRoot);
        String systemProperties = context.getInitParameter(SYSTEM_PROPERTIES);
        if (systemProperties != null && systemProperties.trim().length() > 0) {
            for (String prop : Splitter.on((char)'\n').trimResults().split((CharSequence)systemProperties)) {
                String[] keyAndvalue = StringUtils.split((String)prop, (String)"=", (int)2);
                if (keyAndvalue.length != 2) continue;
                String key = keyAndvalue[0];
                String value = keyAndvalue[1];
                if (key == null || key.trim().length() <= 0 || value == null || value.trim().length() <= 0) continue;
                System.setProperty(key, value);
            }
        }
    }

    @Singleton
    public static class CleanupHandler {
        private List<CleanupCapable> cleanupHandlers = Lists.newArrayList();

        public void register(CleanupCapable cleanupCapable) {
            this.cleanupHandlers.add(cleanupCapable);
        }

        public void cleanup() {
            for (CleanupCapable cleanupHandler : this.cleanupHandlers) {
                cleanupHandler.cleanup();
            }
        }
    }

    public static interface CleanupCapable {
        public void cleanup();
    }
}

