/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.shindig.auth.BasicSecurityTokenCodec;
import org.apache.shindig.auth.BlobCrypterSecurityTokenCodec;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.config.ContainerConfig;

@Singleton
public class DefaultSecurityTokenCodec
implements SecurityTokenCodec {
    private static final String SECURITY_TOKEN_TYPE = "gadgets.securityTokenType";
    private final SecurityTokenCodec codec;

    @Inject
    public DefaultSecurityTokenCodec(ContainerConfig config) {
        String tokenType = config.getString("default", SECURITY_TOKEN_TYPE);
        if ("insecure".equals(tokenType)) {
            this.codec = new BasicSecurityTokenCodec();
        } else if ("secure".equals(tokenType)) {
            this.codec = new BlobCrypterSecurityTokenCodec(config);
        } else {
            throw new RuntimeException("Unknown security token type specified in default container configuration. gadgets.securityTokenType: " + tokenType);
        }
    }

    @Override
    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        return this.codec.createToken(tokenParameters);
    }

    @Override
    public String encodeToken(SecurityToken token) throws SecurityTokenException {
        if (token == null) {
            return null;
        }
        return this.codec.encodeToken(token);
    }

    @Override
    public int getTokenTimeToLive() {
        return this.codec.getTokenTimeToLive();
    }
}

