/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shindig.common.cache.Cache;

public class LruCache<K, V>
extends LinkedHashMap<K, V>
implements Cache<K, V> {
    final int capacity;

    public LruCache(int capacity) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
    }

    @Override
    public synchronized V getElement(K key) {
        return super.get(key);
    }

    @Override
    public synchronized void addElement(K key, V value) {
        super.put(key, value);
    }

    @Override
    public synchronized V removeElement(K key) {
        return super.remove(key);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getSize() {
        return this.size();
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }
}

