/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.crypto;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.common.util.Utf8UrlCoder;

public class BasicBlobCrypter
implements BlobCrypter {
    private static final byte CIPHER_KEY_LABEL = 0;
    private static final byte HMAC_KEY_LABEL = 1;
    public static final int MASTER_KEY_MIN_LEN = 16;
    public TimeSource timeSource = new TimeSource();
    private byte[] cipherKey;
    private byte[] hmacKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicBlobCrypter(File keyfile) throws IOException {
        BufferedReader reader = null;
        try {
            FileInputStream openFile = new FileInputStream(keyfile);
            reader = new BufferedReader(new InputStreamReader((InputStream)openFile, Charsets.UTF_8));
            this.init(reader.readLine());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public BasicBlobCrypter(byte[] masterKey) {
        this.init(masterKey);
    }

    public BasicBlobCrypter(String masterKey) {
        this.init(masterKey);
    }

    private void init(String masterKey) {
        if (masterKey == null) {
            throw new IllegalArgumentException("Unexpectedly empty masterKey:" + masterKey);
        }
        masterKey = masterKey.trim();
        byte[] keyBytes = CharsetUtil.getUtf8Bytes(masterKey);
        this.init(keyBytes);
    }

    private void init(byte[] masterKey) {
        Preconditions.checkArgument((masterKey.length >= 16 ? 1 : 0) != 0, (String)"Master key needs at least %s bytes", (Object[])new Object[]{16});
        this.cipherKey = this.deriveKey((byte)0, masterKey, 16);
        this.hmacKey = this.deriveKey((byte)1, masterKey, 0);
    }

    private byte[] deriveKey(byte label, byte[] masterKey, int len) {
        byte[] base = Bytes.concat((byte[][])new byte[][]{{label}, masterKey});
        byte[] hash = DigestUtils.sha((byte[])base);
        if (len == 0) {
            return hash;
        }
        byte[] out = new byte[len];
        System.arraycopy(hash, 0, out, 0, out.length);
        return out;
    }

    @Override
    public String wrap(Map<String, String> in) throws BlobCrypterException {
        try {
            byte[] encoded = this.serialize(in);
            byte[] cipherText = Crypto.aes128cbcEncrypt(this.cipherKey, encoded);
            byte[] hmac = Crypto.hmacSha1(this.hmacKey, cipherText);
            byte[] b64 = Base64.encodeBase64URLSafe((byte[])Bytes.concat((byte[][])new byte[][]{cipherText, hmac}));
            return CharsetUtil.newUtf8String(b64);
        }
        catch (GeneralSecurityException e) {
            throw new BlobCrypterException(e);
        }
    }

    private byte[] serialize(Map<String, String> in) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> val : in.entrySet()) {
            sb.append(Utf8UrlCoder.encode(val.getKey()));
            sb.append('=');
            sb.append(Utf8UrlCoder.encode(val.getValue()));
            sb.append('&');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return CharsetUtil.getUtf8Bytes(sb.toString());
    }

    @Override
    public Map<String, String> unwrap(String in) throws BlobCrypterException {
        try {
            byte[] bin = Base64.decodeBase64((byte[])CharsetUtil.getUtf8Bytes(in));
            byte[] hmac = new byte[20];
            byte[] cipherText = new byte[bin.length - 20];
            System.arraycopy(bin, 0, cipherText, 0, cipherText.length);
            System.arraycopy(bin, cipherText.length, hmac, 0, hmac.length);
            Crypto.hmacSha1Verify(this.hmacKey, cipherText, hmac);
            byte[] plain = Crypto.aes128cbcDecrypt(this.cipherKey, cipherText);
            Map<String, String> out = this.deserialize(plain);
            return out;
        }
        catch (GeneralSecurityException e) {
            throw new BlobCrypterException("Invalid token signature", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BlobCrypterException("Invalid token format", e);
        }
        catch (NegativeArraySizeException e) {
            throw new BlobCrypterException("Invalid token format", e);
        }
    }

    private Map<String, String> deserialize(byte[] plain) {
        String base = CharsetUtil.newUtf8String(plain);
        String[] items = StringUtils.splitPreserveAllTokens((String)base, (String)"&=");
        HashMap map = Maps.newHashMapWithExpectedSize((int)items.length);
        int i = 0;
        while (i < items.length) {
            String key = Utf8UrlCoder.decode(items[i++]);
            String val = Utf8UrlCoder.decode(items[i++]);
            map.put(key, val);
        }
        return map;
    }
}

