/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.servlet.ServletRequestContext;

public class BasicAuthority
implements Authority {
    private final String host;
    private final String port;
    public static final String JETTY_HOST = "jetty.host";
    public static final String JETTY_PORT = "jetty.port";

    @Inject
    public BasicAuthority(@Nullable @Named(value="shindig.host") String defaultHost, @Nullable @Named(value="shindig.port") String defaultPort) {
        this.host = StringUtils.isNotBlank((String)defaultHost) ? defaultHost : null;
        this.port = StringUtils.isNotBlank((String)defaultPort) ? defaultPort : null;
    }

    @Override
    public String getAuthority() {
        return Joiner.on((char)':').join(Objects.firstNonNull((Object)this.host, (Object)this.getServerHostname()), Objects.firstNonNull((Object)this.port, (Object)this.getServerPort()), new Object[0]);
    }

    @Override
    public String getScheme() {
        return (String)Objects.firstNonNull((Object)ServletRequestContext.getScheme(), (Object)"http");
    }

    @Override
    public String getOrigin() {
        return this.getScheme() + "://" + this.getAuthority();
    }

    private String getServerPort() {
        return (String)Objects.firstNonNull((Object)ServletRequestContext.getPort(), (Object)Objects.firstNonNull((Object)System.getProperty(JETTY_PORT), (Object)"8080"));
    }

    private String getServerHostname() {
        return (String)Objects.firstNonNull((Object)ServletRequestContext.getHost(), (Object)Objects.firstNonNull((Object)System.getProperty(JETTY_HOST), (Object)"localhost"));
    }
}

