/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import org.apache.commons.lang.ArrayUtils;

public final class CharsetUtil {
    private CharsetUtil() {
    }

    public static byte[] getUtf8Bytes(String s) {
        if (s == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        ByteBuffer bb = Charsets.UTF_8.encode(s);
        return ArrayUtils.subarray((byte[])bb.array(), (int)0, (int)bb.limit());
    }

    public static String newUtf8String(byte[] b) {
        return Charsets.UTF_8.decode(ByteBuffer.wrap(b)).toString();
    }
}

