/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigException;

public class BasicContainerConfig
implements ContainerConfig {
    protected final Set<ContainerConfig.ConfigObserver> observers = Sets.newSetFromMap(new WeakHashMap());
    protected Map<String, Map<String, Object>> config = Maps.newHashMap();

    @Override
    public Collection<String> getContainers() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    @Override
    public Map<String, Object> getProperties(String container) {
        return this.config.get(container);
    }

    @Override
    public Object getProperty(String container, String name) {
        Map<String, Object> containerData = this.config.get(container);
        if (containerData == null) {
            return null;
        }
        return containerData.get(name);
    }

    @Override
    public String getString(String container, String property) {
        Object value = this.getProperty(container, property);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public int getInt(String container, String property) {
        Object value = this.getProperty(container, property);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    @Override
    public boolean getBool(String container, String property) {
        Object value = this.getProperty(container, property);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase((String)value);
        }
        return false;
    }

    @Override
    public <T> List<T> getList(String container, String property) {
        Object value = this.getProperty(container, property);
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.emptyList();
    }

    @Override
    public <T> Map<String, T> getMap(String container, String property) {
        Object value = this.getProperty(container, property);
        if (value instanceof Map) {
            return (Map)value;
        }
        return Collections.emptyMap();
    }

    @Override
    public void addConfigObserver(ContainerConfig.ConfigObserver observer, boolean notifyNow) {
        this.observers.add(observer);
        if (notifyNow) {
            this.notifyObservers(this.getContainers(), (Collection<String>)ImmutableSet.of());
        }
    }

    @Override
    public ContainerConfig.Transaction newTransaction() {
        return new BasicTransaction();
    }

    protected void notifyObservers(Collection<String> changed, Collection<String> removed) {
        for (ContainerConfig.ConfigObserver observer : this.observers) {
            observer.containersChanged(this, changed, removed);
        }
    }

    public String toString() {
        return JsonSerializer.serialize(this.config);
    }

    protected class BasicTransaction
    implements ContainerConfig.Transaction {
        protected boolean clear = false;
        protected Map<String, Map<String, Object>> setContainers = Maps.newHashMap();
        protected Set<String> removeContainers = Sets.newHashSet();
        protected ContainerConfigException throwException = null;

        protected BasicTransaction() {
        }

        @Override
        public ContainerConfig.Transaction clearContainers() {
            this.clear = true;
            return this;
        }

        @Override
        public ContainerConfig.Transaction addContainer(Map<String, Object> container) {
            Object names = container.get("gadgets.container");
            if (names instanceof Collection) {
                for (Object name : (Collection)names) {
                    this.setContainers.put(name.toString(), container);
                }
            } else if (names != null) {
                this.setContainers.put(names.toString(), container);
            } else {
                this.throwException = new ContainerConfigException("A container configuration doesn't have the gadgets.container property");
            }
            return this;
        }

        @Override
        public ContainerConfig.Transaction removeContainer(String name) {
            this.removeContainers.add(name);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws ContainerConfigException {
            if (this.throwException != null) {
                throw this.throwException;
            }
            HashSet removed = Sets.newHashSet();
            HashSet changed = Sets.newHashSet();
            BasicContainerConfig basicContainerConfig = BasicContainerConfig.this;
            synchronized (basicContainerConfig) {
                BasicContainerConfig tmpConfig = this.getTemporaryConfig(!this.clear);
                this.changeContainersInConfig(tmpConfig, this.setContainers, this.removeContainers);
                this.diffConfiguration(tmpConfig, changed, removed);
                this.setNewConfig(tmpConfig);
            }
            BasicContainerConfig.this.notifyObservers(changed, removed);
        }

        protected BasicContainerConfig getTemporaryConfig(boolean copyValues) {
            BasicContainerConfig tmp = new BasicContainerConfig();
            if (copyValues) {
                tmp.config = this.deepCopyConfig(BasicContainerConfig.this.config);
            }
            return tmp;
        }

        protected void changeContainersInConfig(BasicContainerConfig newConfig, Map<String, Map<String, Object>> setContainers, Set<String> removeContainers) throws ContainerConfigException {
            newConfig.config.putAll(setContainers);
            for (String container : removeContainers) {
                newConfig.config.remove(container);
            }
            for (String container : newConfig.config.keySet()) {
                newConfig.config.put(container, this.mergeParents(container, newConfig.config));
            }
        }

        protected void setNewConfig(BasicContainerConfig newConfig) {
            BasicContainerConfig.this.config = newConfig.config;
        }

        protected Map<String, Object> mergeParents(String name, Map<String, Map<String, Object>> config) throws ContainerConfigException {
            String parent;
            Map<String, Object> container = config.get(name);
            if ("default".equals(name)) {
                return container;
            }
            String string = parent = container.get("parent") != null ? container.get("parent").toString() : "default";
            if (!config.containsKey(parent)) {
                throw new ContainerConfigException("Unable to locate parent '" + parent + "' required by " + container.get("gadgets.container"));
            }
            return this.mergeObjects(this.mergeParents(parent, config), container);
        }

        private Map<String, Object> mergeObjects(Map<String, Object> parentValues, Map<String, Object> container) {
            HashMap clone = Maps.newHashMap(parentValues);
            for (Map.Entry<String, Object> entry : container.entrySet()) {
                String field = entry.getKey();
                Object fromParents = clone.get(field);
                Object fromContainer = entry.getValue();
                if (fromContainer instanceof Map && fromParents instanceof Map) {
                    clone.put(field, this.mergeObjects((Map)fromParents, (Map)fromContainer));
                    continue;
                }
                clone.put(field, fromContainer);
            }
            return clone;
        }

        private void diffConfiguration(BasicContainerConfig newConfig, Set<String> changed, Set<String> removed) {
            removed.addAll((Collection<String>)Sets.difference(BasicContainerConfig.this.config.keySet(), newConfig.config.keySet()));
            for (String container : newConfig.config.keySet()) {
                if (((Object)newConfig.config.get(container)).equals(BasicContainerConfig.this.config.get(container))) continue;
                changed.add(container);
            }
        }

        protected Map<String, Map<String, Object>> deepCopyConfig(Map<String, Map<String, Object>> config) {
            return (Map)this.deepCopyObject(config);
        }

        private Object deepCopyObject(Object obj) {
            if (obj instanceof Map) {
                Map objMap = (Map)obj;
                HashMap map = Maps.newHashMap();
                for (Map.Entry entry : objMap.entrySet()) {
                    map.put(entry.getKey(), this.deepCopyObject(entry.getValue()));
                }
                return map;
            }
            if (obj instanceof List) {
                List objList = (List)obj;
                ArrayList list = Lists.newArrayList();
                for (Object elem : objList) {
                    list.add(this.deepCopyObject(elem));
                }
                return list;
            }
            return obj;
        }
    }
}

