/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import javax.el.ELException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.expressions.Functions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class OpensocialFunctions {
    private OpensocialFunctions() {
    }

    @Functions.Expose(prefix="osx", names={"parseJson"})
    public static Object parseJson(String text) {
        if (text == null || "".equals(text)) {
            return null;
        }
        try {
            if (text.startsWith("[")) {
                return new JSONArray(text);
            }
            return new JSONObject(text);
        }
        catch (JSONException je) {
            throw new ELException((Throwable)je);
        }
    }

    @Functions.Expose(prefix="osx", names={"decodeBase64"})
    public static String decodeBase64(String text) {
        if (text == null) {
            return null;
        }
        return CharsetUtil.newUtf8String(Base64.decodeBase64((byte[])CharsetUtil.getUtf8Bytes(text)));
    }

    @Functions.Expose(prefix="os", names={"urlEncode"})
    public static String formEncode(String text) {
        if (text == null) {
            return null;
        }
        return Utf8UrlCoder.encode(text);
    }

    @Functions.Expose(prefix="os", names={"urlDecode"})
    public static String formDecode(String text) {
        if (text == null) {
            return null;
        }
        return Utf8UrlCoder.decode(text);
    }

    @Functions.Expose(prefix="os", names={"htmlEncode"})
    public static String htmlEncode(String text) {
        if (text == null) {
            return null;
        }
        return StringEscapeUtils.escapeHtml((String)text);
    }

    @Functions.Expose(prefix="os", names={"htmlDecode"})
    public static String htmlDecode(String text) {
        if (text == null) {
            return null;
        }
        return StringEscapeUtils.unescapeHtml((String)text);
    }
}

