/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultHandlerRegistry
implements HandlerRegistry {
    private static final Logger LOG = Logger.getLogger(DefaultHandlerRegistry.class.getName());
    private final Map<String, Map<String, SortedSet<RestPath>>> serviceMethodPathMap = Maps.newHashMap();
    private final Map<String, RpcInvocationHandler> rpcOperations = Maps.newHashMap();
    private final Injector injector;
    private final BeanJsonConverter beanJsonConverter;
    private final HandlerExecutionListener executionListener;

    @Inject
    public DefaultHandlerRegistry(Injector injector, BeanJsonConverter beanJsonConverter, HandlerExecutionListener executionListener) {
        this.injector = injector;
        this.beanJsonConverter = beanJsonConverter;
        this.executionListener = executionListener;
    }

    @Override
    public void addHandlers(Set<Object> handlers) {
        for (final Object handler : handlers) {
            Provider handlerProvider;
            Class<?> handlerType;
            if (handler instanceof Class) {
                handlerType = (Class<?>)handler;
                handlerProvider = this.injector.getProvider(handlerType);
            } else {
                handlerType = handler.getClass();
                handlerProvider = new Provider<Object>(){

                    public Object get() {
                        return handler;
                    }
                };
            }
            Preconditions.checkState((boolean)handlerType.isAnnotationPresent(Service.class), (String)"Attempt to bind unannotated service implementation %s", (Object[])new Object[]{handlerType.getName()});
            Service service = handlerType.getAnnotation(Service.class);
            for (Method m : handlerType.getMethods()) {
                if (!m.isAnnotationPresent(Operation.class)) continue;
                Operation op = m.getAnnotation(Operation.class);
                this.createRpcHandler(handlerProvider, service, op, m);
                this.createRestHandler(handlerProvider, service, op, m);
            }
        }
    }

    @Override
    public RpcHandler getRpcHandler(JSONObject rpc) {
        try {
            String key = rpc.getString("method");
            RpcInvocationHandler rpcHandler = this.rpcOperations.get(key);
            if (rpcHandler == null) {
                return new ErrorRpcHandler(new ProtocolException(501, "The method " + key + " is not implemented"));
            }
            return new RpcInvocationWrapper(rpcHandler, rpc);
        }
        catch (JSONException je) {
            return new ErrorRpcHandler(new ProtocolException(400, "No method requested in RPC"));
        }
    }

    @Override
    public RestHandler getRestHandler(String path, String method) {
        method = method.toUpperCase();
        if (path != null) {
            SortedSet<RestPath> paths;
            String[] pathParts;
            Map<String, SortedSet<RestPath>> methods;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((methods = this.serviceMethodPathMap.get((pathParts = StringUtils.splitPreserveAllTokens((String)path, (char)'/'))[0])) != null && (paths = methods.get(method)) != null) {
                for (RestPath restPath : paths) {
                    RestInvocationWrapper handler = restPath.accept(pathParts);
                    if (handler == null) continue;
                    return handler;
                }
            }
        }
        return new ErrorRestHandler(new ProtocolException(501, "No service defined for path " + path));
    }

    @Override
    public Set<String> getSupportedRestServices() {
        TreeSet result = Sets.newTreeSet();
        for (Map<String, SortedSet<RestPath>> methods : this.serviceMethodPathMap.values()) {
            for (Map.Entry<String, SortedSet<RestPath>> method : methods.entrySet()) {
                for (RestPath path : method.getValue()) {
                    result.add(method.getKey() + ' ' + path.operationPath);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<String> getSupportedRpcServices() {
        return Collections.unmodifiableSet(this.rpcOperations.keySet());
    }

    private void createRestHandler(Provider<?> handlerProvider, Service service, Operation op, Method m) {
        try {
            MethodCaller methodCaller = new MethodCaller(m, true);
            String opName = m.getName();
            if (!Strings.isNullOrEmpty((String)op.name())) {
                opName = op.name();
            }
            RestInvocationHandler restHandler = new RestInvocationHandler(op, methodCaller, handlerProvider, this.beanJsonConverter, new ExecutionListenerWrapper(service.name(), opName, this.executionListener));
            String serviceName = service.name();
            HashMap methods = this.serviceMethodPathMap.get(serviceName);
            if (methods == null) {
                methods = Maps.newHashMap();
                this.serviceMethodPathMap.put(serviceName, methods);
            }
            for (String httpMethod : op.httpMethods()) {
                if (Strings.isNullOrEmpty((String)httpMethod)) continue;
                SortedSet sortedSet = (SortedSet)methods.get(httpMethod = httpMethod.toUpperCase());
                if (sortedSet == null) {
                    sortedSet = Sets.newTreeSet();
                    methods.put(httpMethod, sortedSet);
                }
                if (Strings.isNullOrEmpty((String)op.path())) {
                    sortedSet.add(new RestPath('/' + serviceName + service.path(), restHandler));
                    continue;
                }
                sortedSet.add(new RestPath('/' + serviceName + op.path(), restHandler));
            }
        }
        catch (NoSuchMethodException nme) {
            LOG.log(Level.INFO, "No REST binding for " + service.name() + '.' + m.getName());
        }
    }

    private void createRpcHandler(Provider<?> handlerProvider, Service service, Operation op, Method m) {
        try {
            MethodCaller methodCaller = new MethodCaller(m, false);
            String opName = m.getName();
            if (op.name().length() > 0) {
                opName = op.name();
            }
            RpcInvocationHandler rpcHandler = new RpcInvocationHandler(methodCaller, handlerProvider, this.beanJsonConverter, new ExecutionListenerWrapper(service.name(), opName, this.executionListener));
            this.rpcOperations.put(service.name() + '.' + opName, rpcHandler);
        }
        catch (NoSuchMethodException nme) {
            LOG.log(Level.INFO, "No RPC binding for " + service.name() + '.' + m.getName());
        }
    }

    static class RestPath
    implements Comparable<RestPath> {
        final String operationPath;
        final List<Part> parts;
        final RestInvocationHandler handler;
        final int constCount;
        final int lastConstIndex;

        public RestPath(String path, RestInvocationHandler handler) {
            int tmpConstCount = 0;
            int tmpConstIndex = -1;
            this.operationPath = path;
            String[] partArr = StringUtils.split((String)path.substring(1), (char)'/');
            this.parts = Lists.newArrayList();
            for (int i = 0; i < partArr.length; ++i) {
                String part = partArr[i];
                if (part.startsWith("{")) {
                    if (part.endsWith("}+")) {
                        this.parts.add(new Part(part.substring(1, part.length() - 2), PartType.PLURAL_PARAM));
                        continue;
                    }
                    if (part.endsWith("}")) {
                        this.parts.add(new Part(part.substring(1, part.length() - 1), PartType.SINGULAR_PARAM));
                        continue;
                    }
                    throw new IllegalStateException("Invalid REST path part format " + part);
                }
                this.parts.add(new Part(part, PartType.CONST));
                ++tmpConstCount;
                tmpConstIndex = i;
            }
            this.constCount = tmpConstCount;
            this.lastConstIndex = tmpConstIndex;
            this.handler = handler;
        }

        public RestInvocationWrapper accept(String[] requestPathParts) {
            if (this.constCount > 0) {
                if (this.lastConstIndex >= requestPathParts.length) {
                    return null;
                }
                for (int i = 0; i <= this.lastConstIndex; ++i) {
                    if (this.parts.get((int)i).type != PartType.CONST || this.parts.get((int)i).partName.equals(requestPathParts[i])) continue;
                    return null;
                }
            }
            HashMap parsedParams = Maps.newHashMap();
            for (int i = 0; i < Math.min(requestPathParts.length, this.parts.size()); ++i) {
                if (this.parts.get((int)i).type == PartType.SINGULAR_PARAM) {
                    if (requestPathParts[i].indexOf(44) != -1) {
                        throw new ProtocolException(400, "Cannot expect plural value " + requestPathParts[i] + " for singular field " + this.parts.get(i) + " for path " + this.operationPath);
                    }
                    parsedParams.put(this.parts.get((int)i).partName, new String[]{requestPathParts[i]});
                    continue;
                }
                if (this.parts.get((int)i).type != PartType.PLURAL_PARAM) continue;
                parsedParams.put(this.parts.get((int)i).partName, StringUtils.splitPreserveAllTokens((String)requestPathParts[i], (char)','));
            }
            return new RestInvocationWrapper(parsedParams, this.handler);
        }

        public boolean equals(Object other) {
            if (other instanceof RestPath) {
                RestPath that = (RestPath)other;
                return this.constCount == that.constCount && this.lastConstIndex == that.lastConstIndex && Objects.equal((Object)this.operationPath, (Object)that.operationPath);
            }
            return false;
        }

        public int hashCode() {
            return this.constCount ^ this.lastConstIndex ^ this.operationPath.hashCode();
        }

        @Override
        public int compareTo(RestPath other) {
            int result = other.constCount - this.constCount;
            if (result == 0) {
                result = this.lastConstIndex - other.lastConstIndex;
            }
            if (result == 0) {
                result = this.operationPath.compareTo(other.operationPath);
            }
            return result;
        }

        static class Part {
            String partName;
            PartType type;

            Part(String partName, PartType type) {
                this.partName = partName;
                this.type = type;
            }
        }

        static enum PartType {
            CONST,
            SINGULAR_PARAM,
            PLURAL_PARAM;

        }
    }

    private static final class ErrorRpcHandler
    implements RpcHandler {
        private final ProtocolException error;

        public ErrorRpcHandler(ProtocolException error) {
            this.error = error;
        }

        @Override
        public Future<?> execute(Map<String, FormDataItem> formItems, SecurityToken token, BeanConverter converter) {
            return ImmediateFuture.errorInstance(this.error);
        }
    }

    private static final class ErrorRestHandler
    implements RestHandler {
        private final ProtocolException error;

        public ErrorRestHandler(ProtocolException error) {
            this.error = error;
        }

        @Override
        public Future<?> execute(Map<String, String[]> parameters, Reader body, SecurityToken token, BeanConverter converter) {
            return ImmediateFuture.errorInstance(this.error);
        }
    }

    private static class MethodCaller {
        private Class<?> inputClass;
        private final Constructor<?> restRequestItemConstructor;
        private final Constructor<?> rpcRequestItemConstructor;
        private final Method method;

        public MethodCaller(Method method, boolean isRest) throws NoSuchMethodException {
            this.method = method;
            Class<?> clazz = this.inputClass = method.getParameterTypes().length > 0 ? method.getParameterTypes()[0] : null;
            if (RequestItem.class.equals(this.inputClass)) {
                this.inputClass = BaseRequestItem.class;
            }
            boolean inputIsRequestItem = this.inputClass != null && RequestItem.class.isAssignableFrom(this.inputClass);
            Class requestItemType = inputIsRequestItem ? this.inputClass : BaseRequestItem.class;
            this.restRequestItemConstructor = requestItemType.getConstructor(Map.class, SecurityToken.class, BeanConverter.class, BeanJsonConverter.class);
            this.rpcRequestItemConstructor = requestItemType.getConstructor(JSONObject.class, Map.class, SecurityToken.class, BeanConverter.class, BeanJsonConverter.class);
        }

        public RequestItem getRestRequestItem(Map<String, String[]> params, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
            return this.getRequestItem(params, token, converter, jsonConverter, this.restRequestItemConstructor);
        }

        public RequestItem getRpcRequestItem(JSONObject params, Map<String, FormDataItem> formItems, SecurityToken token, BeanJsonConverter converter) {
            return this.getRequestItem(params, formItems, token, converter, converter, this.rpcRequestItemConstructor);
        }

        private RequestItem getRequestItem(Object params, Map<String, FormDataItem> formItems, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter, Constructor<?> constructor) {
            try {
                return (RequestItem)constructor.newInstance(params, formItems, token, converter, jsonConverter);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private RequestItem getRequestItem(Object params, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter, Constructor<?> constructor) {
            try {
                return (RequestItem)constructor.newInstance(params, token, converter, jsonConverter);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public Future<?> call(Object handler, RequestItem item) {
            try {
                Object result = this.inputClass == null ? this.method.invoke(handler, new Object[0]) : (RequestItem.class.isAssignableFrom(this.inputClass) ? this.method.invoke(handler, item) : this.method.invoke(handler, item.getTypedRequest(this.inputClass)));
                if (result instanceof Future) {
                    return (Future)result;
                }
                return ImmediateFuture.newInstance(result);
            }
            catch (IllegalAccessException e) {
                return ImmediateFuture.errorInstance(e);
            }
            catch (InvocationTargetException e) {
                return ImmediateFuture.errorInstance(e.getTargetException());
            }
        }
    }

    static class RestInvocationWrapper
    implements RestHandler {
        RestInvocationHandler handler;
        Map<String, String[]> pathParams;

        RestInvocationWrapper(Map<String, String[]> pathParams, RestInvocationHandler handler) {
            this.pathParams = pathParams;
            this.handler = handler;
        }

        @Override
        public Future<?> execute(Map<String, String[]> parameters, Reader body, SecurityToken token, BeanConverter converter) {
            this.pathParams.putAll(parameters);
            return this.handler.execute(this.pathParams, body, token, converter);
        }
    }

    static final class RestInvocationHandler {
        final Provider<?> handlerProvider;
        final Operation operation;
        final BeanJsonConverter beanJsonConverter;
        final ExecutionListenerWrapper listener;
        final MethodCaller methodCaller;

        private RestInvocationHandler(Operation operation, MethodCaller methodCaller, Provider<?> handlerProvider, BeanJsonConverter beanJsonConverter, ExecutionListenerWrapper listener) {
            this.operation = operation;
            this.handlerProvider = handlerProvider;
            this.beanJsonConverter = beanJsonConverter;
            this.listener = listener;
            this.methodCaller = methodCaller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Future<?> execute(Map<String, String[]> parameters, Reader body, SecurityToken token, BeanConverter converter) {
            RequestItem item;
            try {
                if (body != null) {
                    parameters.put(this.operation.bodyParam(), new String[]{IOUtils.toString((Reader)body)});
                }
                item = this.methodCaller.getRestRequestItem(parameters, token, converter, this.beanJsonConverter);
            }
            catch (Exception e) {
                return ImmediateFuture.errorInstance(e);
            }
            try {
                this.listener.executing(item);
                Future<?> e = this.methodCaller.call(this.handlerProvider.get(), item);
                return e;
            }
            catch (Exception e) {
                Future future = ImmediateFuture.errorInstance(e);
                return future;
            }
            finally {
                this.listener.executed(item);
            }
        }
    }

    static final class RpcInvocationWrapper
    implements RpcHandler {
        final RpcInvocationHandler handler;
        final JSONObject rpc;

        RpcInvocationWrapper(RpcInvocationHandler handler, JSONObject rpc) {
            this.handler = handler;
            this.rpc = rpc;
        }

        @Override
        public Future<?> execute(Map<String, FormDataItem> formItems, SecurityToken st, BeanConverter converter) {
            return this.handler.execute(this.rpc, formItems, st, converter);
        }
    }

    static final class RpcInvocationHandler {
        private Provider<?> handlerProvider;
        private BeanJsonConverter beanJsonConverter;
        private ExecutionListenerWrapper listener;
        private MethodCaller methodCaller;

        private RpcInvocationHandler(MethodCaller methodCaller, Provider<?> handlerProvider, BeanJsonConverter beanJsonConverter, ExecutionListenerWrapper listener) {
            this.handlerProvider = handlerProvider;
            this.beanJsonConverter = beanJsonConverter;
            this.listener = listener;
            this.methodCaller = methodCaller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Future<?> execute(JSONObject rpc, Map<String, FormDataItem> formItems, SecurityToken token, BeanConverter converter) {
            RequestItem item;
            try {
                JSONObject params = rpc.has("params") ? (JSONObject)rpc.get("params") : new JSONObject();
                item = this.methodCaller.getRpcRequestItem(params, formItems, token, this.beanJsonConverter);
            }
            catch (Exception e) {
                return ImmediateFuture.errorInstance(e);
            }
            try {
                this.listener.executing(item);
                Future<?> e = this.methodCaller.call(this.handlerProvider.get(), item);
                return e;
            }
            catch (Exception e) {
                Future future = ImmediateFuture.errorInstance(e);
                return future;
            }
            finally {
                this.listener.executed(item);
            }
        }
    }

    private static class ExecutionListenerWrapper {
        final String service;
        final String operation;
        final HandlerExecutionListener listener;

        ExecutionListenerWrapper(String service, String operation, HandlerExecutionListener listener) {
            this.service = service;
            this.operation = operation;
            this.listener = listener;
        }

        private void executing(RequestItem req) {
            this.listener.executing(this.service, this.operation, req);
        }

        private void executed(RequestItem req) {
            this.listener.executed(this.service, this.operation, req);
        }
    }
}

