/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.encoding;

import com.google.common.base.Charsets;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.nio.charset.Charset;

public final class EncodingDetector {
    private EncodingDetector() {
    }

    public static Charset detectEncoding(byte[] input, boolean assume88591IfNotUtf8, FallbackEncodingDetector alternateDecoder) {
        if (EncodingDetector.looksLikeValidUtf8(input)) {
            return Charsets.UTF_8;
        }
        if (assume88591IfNotUtf8) {
            return Charsets.ISO_8859_1;
        }
        return alternateDecoder.detectEncoding(input);
    }

    private static boolean looksLikeValidUtf8(byte[] input) {
        int i = 0;
        if (input.length >= 3 && (input[0] & 0xFF) == 239 && (input[1] & 0xFF) == 187 && (input[2] & 0xFF) == 191) {
            i = 3;
        }
        int j = input.length;
        while (i < j) {
            byte bite = input[i];
            if ((bite & 0x80) != 0) {
                int endOfSequence;
                if ((bite & 0xE0) == 192) {
                    endOfSequence = i + 1;
                } else if ((bite & 0xF0) == 224) {
                    endOfSequence = i + 2;
                } else if ((bite & 0xF8) == 240) {
                    endOfSequence = i + 3;
                } else {
                    return false;
                }
                if (endOfSequence >= j) {
                    return false;
                }
                while (i < endOfSequence) {
                    if (((bite = input[++i]) & 0xC0) == 128) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static class FallbackEncodingDetector {
        public Charset detectEncoding(byte[] input) {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(input);
            CharsetMatch match = detector.detect();
            return Charset.forName(match.getName().toUpperCase());
        }
    }
}

