/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

@Singleton
public class BasicHttpFetcher
implements HttpFetcher {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 5000;
    private static final int DEFAULT_MAX_OBJECT_SIZE = 0;
    private static final long DEFAULT_SLOW_RESPONSE_WARNING = 10000L;
    protected final HttpClient FETCHER;
    private volatile int maxObjSize;
    private volatile long slowResponseWarning;
    private static final Logger LOG = Logger.getLogger(BasicHttpFetcher.class.getName());
    private final Set<Class<?>> TIMEOUT_EXCEPTIONS = ImmutableSet.of(ConnectionPoolTimeoutException.class, SocketTimeoutException.class, SocketException.class, HttpHostConnectException.class, NoHttpResponseException.class, InterruptedException.class, (Object[])new Class[]{UnknownHostException.class});

    @Inject
    public BasicHttpFetcher(@Nullable @Named(value="org.apache.shindig.gadgets.http.basicHttpFetcherProxy") String basicHttpFetcherProxy) {
        this(0, 5000, 5000, basicHttpFetcherProxy);
    }

    public BasicHttpFetcher(int maxObjSize, int connectionTimeoutMs, int readTimeoutMs, String basicHttpFetcherProxy) {
        this.setMaxObjectSizeBytes(maxObjSize);
        this.setSlowResponseWarning(10000L);
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)params, (long)connectionTimeoutMs);
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)1152);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(256));
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Apache Shindig");
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeoutMs);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeoutMs);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)true);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
        HttpClientParams.setAuthenticating((HttpParams)params, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        if (!StringUtils.isEmpty((String)basicHttpFetcherProxy)) {
            String[] splits = basicHttpFetcherProxy.split(":");
            ConnRouteParams.setDefaultProxy((HttpParams)client.getParams(), (HttpHost)new HttpHost(splits[0], Integer.parseInt(splits[1]), "http"));
        }
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, true));
        client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(org.apache.http.HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip, deflate");
                }
            }
        });
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(org.apache.http.HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header ceheader;
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    for (HeaderElement codec : ceheader.getElements()) {
                        String codecname = codec.getName();
                        if ("gzip".equalsIgnoreCase(codecname)) {
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                        if (!"deflate".equals(codecname)) continue;
                        response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                        return;
                    }
                }
            }
        });
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
        client.removeRequestInterceptorByClass(RequestAddCookies.class);
        client.removeResponseInterceptorByClass(ResponseProcessCookies.class);
        if (StringUtils.isEmpty((String)basicHttpFetcherProxy)) {
            ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
            client.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        this.FETCHER = client;
    }

    public HttpResponse fetch(HttpRequest request) throws GadgetException {
        HttpGet httpMethod = null;
        Preconditions.checkNotNull((Object)request);
        String methodType = request.getMethod();
        long started = System.currentTimeMillis();
        Uri uri = request.getUri();
        if (StringUtils.isEmpty((String)uri.getAuthority())) {
            throw new GadgetException(GadgetException.Code.INVALID_USER_DATA, "Missing domain name for request: " + uri, 400);
        }
        if (StringUtils.isEmpty((String)uri.getScheme())) {
            throw new GadgetException(GadgetException.Code.INVALID_USER_DATA, "Missing schema for request: " + uri, 400);
        }
        String[] hostparts = StringUtils.splitPreserveAllTokens((String)uri.getAuthority(), (char)':');
        int port = -1;
        if (hostparts.length > 2) {
            throw new GadgetException(GadgetException.Code.INVALID_USER_DATA, "Bad host name in request: " + uri.getAuthority(), 400);
        }
        if (hostparts.length == 2) {
            try {
                port = Integer.parseInt(hostparts[1]);
            }
            catch (NumberFormatException e) {
                throw new GadgetException(GadgetException.Code.INVALID_USER_DATA, "Bad port number in request: " + uri.getAuthority(), 400);
            }
        }
        String requestUri = uri.getPath();
        if (uri.getPath() == null) {
            requestUri = "/";
        }
        if (uri.getQuery() != null) {
            requestUri = requestUri + '?' + uri.getQuery();
        }
        HttpHost host = new HttpHost(hostparts[0], port, uri.getScheme());
        try {
            org.apache.http.HttpResponse response;
            if ("POST".equals(methodType) || "PUT".equals(methodType)) {
                HttpPost enclosingMethod;
                Object object = enclosingMethod = "POST".equals(methodType) ? new HttpPost(requestUri) : new HttpPut(requestUri);
                if (request.getPostBodyLength() > 0) {
                    enclosingMethod.setEntity((HttpEntity)new InputStreamEntity(request.getPostBody(), (long)request.getPostBodyLength()));
                }
                httpMethod = enclosingMethod;
            } else if ("GET".equals(methodType)) {
                httpMethod = new HttpGet(requestUri);
            } else if ("HEAD".equals(methodType)) {
                httpMethod = new HttpHead(requestUri);
            } else if ("DELETE".equals(methodType)) {
                httpMethod = new HttpDelete(requestUri);
            }
            for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
                httpMethod.addHeader(entry.getKey(), StringUtils.join((Collection)entry.getValue(), (char)','));
            }
            if (!request.getFollowRedirects()) {
                httpMethod.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
            }
            if ((response = this.FETCHER.execute(host, (org.apache.http.HttpRequest)httpMethod)) == null) {
                throw new IOException("Unknown problem with request");
            }
            long now = System.currentTimeMillis();
            if (now - started > this.slowResponseWarning) {
                this.slowResponseWarning(request, started, now);
            }
            HttpResponse httpResponse = this.makeResponse(response);
            return httpResponse;
        }
        catch (Exception e) {
            long now = System.currentTimeMillis();
            if (this.TIMEOUT_EXCEPTIONS.contains(e.getClass())) {
                LOG.info("Timeout for " + request.getUri() + " Exception: " + e.getClass().getName() + " - " + e.getMessage() + " - " + (now - started) + "ms");
                HttpResponse httpResponse = HttpResponse.timeout();
                return httpResponse;
            }
            LOG.log(Level.INFO, "Got Exception fetching " + request.getUri() + " - " + (now - started) + "ms", e);
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, 500);
        }
        finally {
            if (httpMethod != null) {
                try {
                    httpMethod.abort();
                }
                catch (UnsupportedOperationException e) {}
            }
        }
    }

    protected void slowResponseWarning(HttpRequest request, long started, long finished) {
        LOG.warning("Slow response from " + request.getUri() + ' ' + (finished - started) + "ms");
    }

    @Inject(optional=true)
    public void setMaxObjectSizeBytes(@Named(value="shindig.http.client.max-object-size-bytes") int maxObjectSizeBytes) {
        this.maxObjSize = maxObjectSizeBytes;
    }

    @Inject(optional=true)
    public void setSlowResponseWarning(@Named(value="shindig.http.client.slow-response-warning") long slowResponseWarning) {
        this.slowResponseWarning = slowResponseWarning;
    }

    @Inject(optional=true)
    public void setConnectionTimeoutMs(@Named(value="shindig.http.client.connection-timeout-ms") int connectionTimeoutMs) {
        Preconditions.checkArgument((connectionTimeoutMs > 0 ? 1 : 0) != 0, (Object)"connection-timeout-ms must be greater than 0");
        this.FETCHER.getParams().setIntParameter("http.connection.timeout", connectionTimeoutMs);
    }

    @Inject(optional=true)
    public void setReadTimeoutMs(@Named(value="shindig.http.client.read-timeout-ms") int readTimeoutMs) {
        Preconditions.checkArgument((readTimeoutMs > 0 ? 1 : 0) != 0, (Object)"read-timeout-ms must be greater than 0");
        this.FETCHER.getParams().setIntParameter("http.socket.timeout", readTimeoutMs);
    }

    private HttpResponse makeResponse(org.apache.http.HttpResponse response) throws IOException {
        HttpResponseBuilder builder = new HttpResponseBuilder();
        if (response.getAllHeaders() != null) {
            for (Header h : response.getAllHeaders()) {
                if (h.getName() == null) continue;
                builder.addHeader(h.getName(), h.getValue());
            }
        }
        HttpEntity entity = response.getEntity();
        if (this.maxObjSize > 0 && entity.getContentLength() > (long)this.maxObjSize) {
            return HttpResponse.badrequest("Exceeded maximum number of bytes - " + this.maxObjSize);
        }
        byte[] responseBytes = entity == null ? null : this.toByteArraySafe(entity);
        return builder.setHttpStatusCode(response.getStatusLine().getStatusCode()).setResponse(responseBytes).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArraySafe(HttpEntity entity) throws IOException {
        ByteArrayBuffer buffer;
        block10: {
            if (entity == null) {
                return null;
            }
            InputStream instream = entity.getContent();
            if (instream == null) {
                return new byte[0];
            }
            Preconditions.checkArgument((entity.getContentLength() < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"HTTP entity too large to be buffered in memory");
            int bufferLength = 16384;
            int i = (int)entity.getContentLength();
            if (i < 0) {
                i = 16384;
            }
            buffer = new ByteArrayBuffer(i);
            try {
                int l;
                byte[] tmp = new byte[16384];
                while ((l = instream.read(tmp)) != -1) {
                    buffer.append(tmp, 0, l);
                }
            }
            catch (EOFException eofe) {
                if (instream.available() == 0 && (eofe.getMessage() == null || eofe.getMessage().equals("Unexpected end of ZLIB input stream"))) {
                    LOG.log(Level.FINE, "EOFException: ", eofe);
                    break block10;
                }
                throw eofe;
            }
            finally {
                instream.close();
            }
        }
        return buffer.toByteArray();
    }

    static class DeflateDecompressingEntity
    extends HttpEntityWrapper {
        public DeflateDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream wrappedin = this.wrappedEntity.getContent();
            return new InflaterInputStream(wrappedin, new Inflater(true));
        }

        public long getContentLength() {
            return -1L;
        }
    }

    static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream wrappedin = this.wrappedEntity.getContent();
            return new GZIPInputStream(wrappedin);
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

