/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanitizingProxyUriManager
implements ProxyUriManager {
    private final ProxyUriManager wrapped;
    private final String expectedMime;

    public SanitizingProxyUriManager(ProxyUriManager wrapped, String expectedMime) {
        this.wrapped = wrapped;
        this.expectedMime = expectedMime;
    }

    @Override
    public ProxyUriManager.ProxyUri process(Uri uri) throws GadgetException {
        return this.wrapped.process(uri);
    }

    @Override
    public List<Uri> make(List<ProxyUriManager.ProxyUri> ctx, Integer forcedRefresh) {
        List<Uri> origUris = this.wrapped.make(ctx, forcedRefresh);
        ArrayList sanitizedUris = Lists.newArrayListWithCapacity((int)origUris.size());
        for (Uri origUri : origUris) {
            UriBuilder newUri = new UriBuilder(origUri);
            newUri.addQueryParameter(UriCommon.Param.SANITIZE.getKey(), "1");
            if (this.expectedMime != null) {
                newUri.addQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey(), this.expectedMime);
            }
            sanitizedUris.add(newUri.toUri());
        }
        return sanitizedUris;
    }
}

