/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyUriManager
implements ProxyUriManager {
    public static final String PROXY_HOST_PARAM = "gadgets.uri.proxy.host";
    public static final String PROXY_PATH_PARAM = "gadgets.uri.proxy.path";
    static final String CHAINED_PARAMS_TOKEN = "%chained_params%";
    private final ContainerConfig config;
    private final ProxyUriManager.Versioner versioner;
    private boolean strictParsing = false;

    @Inject
    public DefaultProxyUriManager(ContainerConfig config, @Nullable ProxyUriManager.Versioner versioner) {
        this.config = config;
        this.versioner = versioner;
    }

    @Inject(optional=true)
    public void setUseStrictParsing(@Named(value="shindig.uri.proxy.use-strict-parsing") boolean useStrict) {
        this.strictParsing = useStrict;
    }

    @Override
    public List<Uri> make(List<ProxyUriManager.ProxyUri> resources, Integer forcedRefresh) {
        HashMap versions;
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList resourceUris = Lists.newArrayListWithCapacity((int)resources.size());
        for (ProxyUriManager.ProxyUri puc : resources) {
            resourceUris.add(puc.getResource());
        }
        if (this.versioner == null) {
            versions = Collections.emptyMap();
        } else {
            versions = Maps.newHashMapWithExpectedSize((int)resources.size());
            List<String> versionList = this.versioner.version(resourceUris, resources.get(0).getContainer());
            if (versionList != null && versionList.size() == resources.size()) {
                Iterator<String> versionIt = versionList.iterator();
                for (ProxyUriManager.ProxyUri puc : resources) {
                    versions.put(puc.getResource(), versionIt.next());
                }
            }
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)resources.size());
        for (ProxyUriManager.ProxyUri puc : resources) {
            result.add(this.makeProxiedUri(puc, forcedRefresh, (String)versions.get(puc.getResource())));
        }
        return result;
    }

    private Uri makeProxiedUri(ProxyUriManager.ProxyUri puc, Integer forcedRefresh, String version) {
        UriBuilder queryBuilder = puc.makeQueryParams(forcedRefresh, version);
        String container = puc.getContainer();
        UriBuilder uri = new UriBuilder();
        uri.setAuthority(this.getReqConfig(container, PROXY_HOST_PARAM));
        String path = this.getReqConfig(container, PROXY_PATH_PARAM);
        if (path.contains(CHAINED_PARAMS_TOKEN)) {
            path = path.replace(CHAINED_PARAMS_TOKEN, queryBuilder.getQuery());
            uri.setPath(path);
            String uriStr = uri.toString();
            String curUri = uriStr + (!uriStr.endsWith("/") ? "/" : "") + puc.getResource().toString();
            return Uri.parse((String)curUri);
        }
        queryBuilder.addQueryParameter(UriCommon.Param.URL.getKey(), puc.getResource().toString());
        uri.setQuery(queryBuilder.getQuery());
        uri.setPath(path);
        return uri.toUri();
    }

    @Override
    public ProxyUriManager.ProxyUri process(Uri uriIn) throws GadgetException {
        UriStatus status = UriStatus.BAD_URI;
        Uri uri = null;
        String container = uriIn.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = uriIn.getQueryParameter(UriCommon.Param.SYND.getKey());
        }
        String uriStr = null;
        Uri queryUri = null;
        if (container != null && this.config.getString(container, PROXY_PATH_PARAM) != null && this.config.getString(container, PROXY_PATH_PARAM).equalsIgnoreCase(uriIn.getPath())) {
            uriStr = uriIn.getQueryParameter(UriCommon.Param.URL.getKey());
            queryUri = uriIn;
        } else {
            int start;
            boolean doDecode;
            String containerStr = UriCommon.Param.CONTAINER.getKey() + '=';
            String path = uriIn.getPath();
            boolean bl = doDecode = !path.contains(containerStr);
            if (doDecode) {
                path = Utf8UrlCoder.decode((String)path);
            }
            if ((start = path.indexOf(containerStr)) > 0) {
                String proxyPath;
                int end = path.indexOf(38, start += containerStr.length());
                if (end < start) {
                    end = path.indexOf(47, start);
                }
                if (end > start) {
                    container = path.substring(start, end);
                }
                if (container != null && (proxyPath = this.config.getString(container, PROXY_PATH_PARAM)) != null) {
                    String[] chainedChunks = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)proxyPath, (String)CHAINED_PARAMS_TOKEN);
                    String startToken = chainedChunks[0];
                    String endToken = "/";
                    if (chainedChunks.length == 2 && chainedChunks[1].length() > 0) {
                        endToken = chainedChunks[1];
                    }
                    String fullProxyUri = uriIn.toString();
                    int startIx = fullProxyUri.indexOf(startToken) + startToken.length();
                    int endIx = fullProxyUri.indexOf(endToken, startIx);
                    if (startIx > 0 && endIx > 0) {
                        String chainedQuery = fullProxyUri.substring(startIx, endIx);
                        if (doDecode) {
                            chainedQuery = Utf8UrlCoder.decode((String)chainedQuery);
                        }
                        queryUri = new UriBuilder().setQuery(chainedQuery).toUri();
                        uriStr = fullProxyUri.substring(endIx + endToken.length());
                        while (uriStr.startsWith("/")) {
                            uriStr = uriStr.substring(1);
                        }
                    }
                }
            }
        }
        if (!this.strictParsing && container != null && StringUtils.isEmpty((String)uriStr)) {
            uriStr = uriIn.getQueryParameter(UriCommon.Param.URL.getKey());
            queryUri = uriIn;
        }
        if (StringUtils.isEmpty((String)uriStr) || StringUtils.isEmpty((String)container)) {
            throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, "Missing required parameter(s):" + (StringUtils.isEmpty((String)uriStr) ? ' ' + UriCommon.Param.URL.getKey() : "") + (StringUtils.isEmpty((String)container) ? ' ' + UriCommon.Param.CONTAINER.getKey() : ""), 400);
        }
        String queryHost = this.config.getString(container, PROXY_HOST_PARAM);
        if (this.strictParsing && (queryHost == null || !queryHost.equalsIgnoreCase(uriIn.getAuthority()))) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, "Invalid proxy host", 400);
        }
        try {
            uri = Uri.parse((String)uriStr);
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid " + UriCommon.Param.URL.getKey() + ": " + uriStr, 400);
        }
        status = UriStatus.VALID_UNVERSIONED;
        String version = queryUri.getQueryParameter(UriCommon.Param.VERSION.getKey());
        if (this.versioner != null && version != null) {
            status = this.versioner.validate(uri, container, version);
        }
        ProxyUriManager.ProxyUri proxied = new ProxyUriManager.ProxyUri(status, uri, queryUri);
        proxied.setHtmlTagContext(uriIn.getQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey()));
        return proxied;
    }

    private String getReqConfig(String container, String key) {
        String val = this.config.getString(container, key);
        if (val == null) {
            throw new RuntimeException("Missing required container config key: " + key + " for " + "container: " + container);
        }
        return val;
    }
}

