/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.ContainerConfigException;
import org.apache.shindig.common.JsonContainerConfig;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonContainerConf
implements ContainerConf {
    private static final Logger logger = Logger.getLogger(JsonContainerConf.class.getName());
    private static String containerjs = "res://containers/default/container.js";
    private static String container = "default";
    private JSONObject containerJsonObject;
    private ContainerConfig config;
    private List<String> activityFieldsList;
    private JSONArray personFieldsJsonArray;

    @Inject
    public JsonContainerConf() {
        try {
            this.config = new JsonContainerConfig(containerjs);
        }
        catch (ContainerConfigException e) {
            logger.log(Level.SEVERE, "Not able to load container.js", e);
        }
    }

    @Override
    public Object getContainerObject() throws ContainerConfigException {
        if (this.containerJsonObject == null) {
            this.containerJsonObject = (JSONObject)this.config.getJson(container, null);
        }
        return this.containerJsonObject;
    }

    @Override
    public synchronized List<String> getActivityFieldsList() throws ContainerConfigException {
        this.populateActivityFieldList();
        return this.activityFieldsList;
    }

    public void populateActivityFieldList() throws ContainerConfigException {
        JSONObject gfJsonObject;
        if (this.containerJsonObject == null) {
            this.containerJsonObject = (JSONObject)this.getContainerObject();
        }
        if (this.activityFieldsList != null) {
            return;
        }
        try {
            gfJsonObject = this.containerJsonObject.getJSONObject("gadgets.features");
        }
        catch (JSONException jsone) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, "Error while retrieving JsonObject for gadgets.features from container.js", jsone);
        }
        Iterator itr = gfJsonObject.keys();
        String osKey = null;
        while (itr.hasNext() && !(osKey = itr.next().toString()).startsWith("opensocial")) {
        }
        JSONObject osJsonObjectValue = null;
        JSONObject supportFieldsJsonObjectValue = null;
        JSONArray activityFields = null;
        try {
            osJsonObjectValue = gfJsonObject.getJSONObject(osKey);
            supportFieldsJsonObjectValue = osJsonObjectValue.getJSONObject("supportedFields");
            activityFields = supportFieldsJsonObjectValue.getJSONArray("activity");
            this.activityFieldsList = new LinkedList<String>();
            for (int i = 0; i < activityFields.length(); ++i) {
                this.activityFieldsList.add(activityFields.get(i).toString());
            }
        }
        catch (JSONException jsone) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, jsone.toString(), jsone);
        }
    }

    @Override
    public synchronized Object getPersonFields() throws ContainerConfigException {
        JSONObject gfJsonObject;
        JSONObject jsonObject = (JSONObject)this.getContainerObject();
        try {
            gfJsonObject = jsonObject.getJSONObject("gadgets.features");
        }
        catch (JSONException jsone) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, "Error while retrieving JsonObject for gadgets.features from container.js", jsone);
        }
        Iterator itr = gfJsonObject.keys();
        String osKey = null;
        while (itr.hasNext() && !(osKey = itr.next().toString()).startsWith("opensocial")) {
        }
        JSONObject osJsonObjectValue = null;
        try {
            osJsonObjectValue = gfJsonObject.getJSONObject(osKey);
            JSONObject personFieldsJsonObject = osJsonObjectValue.getJSONObject("supportedFields");
            this.personFieldsJsonArray = personFieldsJsonObject.getJSONArray("person");
        }
        catch (JSONException jsone) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, jsone.toString(), jsone);
        }
        return this.personFieldsJsonArray;
    }
}

