/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.JsonConversionUtil;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.service.ApiServlet;
import org.apache.shindig.social.opensocial.service.ResponseItem;
import org.apache.shindig.social.opensocial.service.RpcRequestItem;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcServlet
extends ApiServlet {
    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        try {
            this.setCharacterEncodings(servletRequest, servletResponse);
            JSONObject request = JsonConversionUtil.fromRequest((HttpServletRequest)servletRequest);
            this.dispatch(request, servletRequest, servletResponse, token);
        }
        catch (JSONException je) {
            // empty catch block
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        this.setCharacterEncodings(servletRequest, servletResponse);
        servletResponse.setContentType("application/json");
        try {
            String content = IOUtils.toString((InputStream)servletRequest.getInputStream(), (String)servletRequest.getCharacterEncoding());
            if (content.indexOf(91) != -1 && content.indexOf(91) < content.indexOf(123)) {
                JSONArray batch = new JSONArray(content);
                this.dispatchBatch(batch, servletRequest, servletResponse, token);
            } else {
                JSONObject request = new JSONObject(content);
                this.dispatch(request, servletRequest, servletResponse, token);
            }
        }
        catch (JSONException je) {
            this.sendBadRequest(je, servletResponse);
        }
    }

    protected void dispatchBatch(JSONArray batch, HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token) throws JSONException, IOException {
        ArrayList responses = Lists.newArrayListWithExpectedSize((int)batch.length());
        for (int i = 0; i < batch.length(); ++i) {
            JSONObject batchObj = batch.getJSONObject(i);
            RpcRequestItem requestItem = new RpcRequestItem(batchObj, token, this.jsonConverter);
            responses.add(this.handleRequestItem(requestItem, servletRequest));
        }
        JSONArray result = new JSONArray();
        for (int i = 0; i < batch.length(); ++i) {
            JSONObject batchObj = batch.getJSONObject(i);
            String key = null;
            if (batchObj.has("id")) {
                key = batchObj.getString("id");
            }
            result.put((Object)this.getJSONResponse(key, this.getResponseItem((Future)responses.get(i))));
        }
        servletResponse.getWriter().write(result.toString());
    }

    protected void dispatch(JSONObject request, HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token) throws JSONException, IOException {
        String key = null;
        if (request.has("id")) {
            key = request.getString("id");
        }
        RpcRequestItem requestItem = new RpcRequestItem(request, token, this.jsonConverter);
        ResponseItem response = this.getResponseItem(this.handleRequestItem(requestItem, servletRequest));
        JSONObject result = this.getJSONResponse(key, response);
        servletResponse.getWriter().write(result.toString());
    }

    private JSONObject getJSONResponse(String key, ResponseItem responseItem) throws JSONException {
        JSONObject result = new JSONObject();
        if (key != null) {
            result.put("id", (Object)key);
        }
        if (responseItem.getError() != null) {
            result.put("error", (Object)this.getErrorJson(responseItem));
        } else {
            Object response = responseItem.getResponse();
            JSONObject converted = (JSONObject)this.jsonConverter.convertToJson(response);
            if (response instanceof RestfulCollection) {
                converted.put("list", converted.remove("entry"));
                result.put("data", (Object)converted);
            } else if (response instanceof DataCollection) {
                if (converted.has("entry")) {
                    result.put("data", converted.get("entry"));
                }
            } else {
                result.put("data", (Object)converted);
            }
        }
        return result;
    }

    private JSONObject getErrorJson(ResponseItem responseItem) throws JSONException {
        JSONObject error = new JSONObject();
        error.put("code", responseItem.getError().getHttpErrorCode());
        String message = responseItem.getError().toString();
        if (StringUtils.isNotBlank((String)responseItem.getErrorMessage())) {
            message = message + ": " + responseItem.getErrorMessage();
        }
        error.put("message", (Object)message);
        return error;
    }

    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        try {
            JSONObject error = this.getErrorJson(responseItem);
            servletResponse.getWriter().write(error.toString());
        }
        catch (JSONException je) {
            servletResponse.sendError(500, "Error generating error response " + je.getMessage());
        }
    }

    private void sendBadRequest(Throwable t, HttpServletResponse response) throws IOException {
        this.sendError(response, new ResponseItem(ResponseError.BAD_REQUEST, "Invalid batch - " + t.getMessage()));
    }
}

