/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import com.google.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2Service;

public class OAuth2AuthenticationHandler
implements AuthenticationHandler {
    private static final String classname = OAuth2AuthenticationHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private OAuth2Service store;

    public String getName() {
        return "OAuth2";
    }

    @Inject
    public OAuth2AuthenticationHandler(OAuth2Service store) {
        this.store = store;
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        OAuth2NormalizedRequest normalizedReq;
        try {
            normalizedReq = new OAuth2NormalizedRequest(request);
        }
        catch (OAuth2Exception oae) {
            LOG.logp(Level.WARNING, classname, "getSecurityTokenFromRequest", "invalidOauth");
            return null;
        }
        try {
            if (normalizedReq.getAccessToken() != null) {
                this.store.validateRequestForResource(normalizedReq, null);
                return new AnonymousSecurityToken();
            }
        }
        catch (OAuth2Exception oae) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Something went wrong: ", (Throwable)oae);
        }
        return null;
    }

    public String getWWWAuthenticateHeader(String realm) {
        return String.format("Bearer realm=\"%s\"", realm);
    }
}

