/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.oauth;

import java.io.Serializable;
import java.util.Date;

public class OAuthEntry
implements Serializable {
    public static final long ONE_YEAR = 31536000000L;
    public static final long FIVE_MINUTES = 300000L;
    static final long serialVersionUID = 2L;
    private String appId;
    private String callbackUrl;
    private boolean callbackUrlSigned;
    private String userId;
    private String token;
    private String tokenSecret;
    private boolean authorized;
    private String consumerKey;
    private Type type;
    private Date issueTime;
    private String domain;
    private String container;
    private String oauthVersion;
    private String callbackToken;
    private int callbackTokenAttempts;

    public OAuthEntry() {
    }

    public OAuthEntry(OAuthEntry old) {
        this.appId = old.appId;
        this.callbackUrl = old.callbackUrl;
        this.callbackUrlSigned = old.callbackUrlSigned;
        this.userId = old.userId;
        this.token = old.token;
        this.tokenSecret = old.tokenSecret;
        this.authorized = old.authorized;
        this.consumerKey = old.consumerKey;
        this.type = old.type;
        this.issueTime = old.issueTime;
        this.domain = old.domain;
        this.container = old.container;
        this.oauthVersion = old.oauthVersion;
        this.callbackToken = old.callbackToken;
        this.callbackTokenAttempts = old.callbackTokenAttempts;
    }

    public boolean isExpired() {
        Date currentDate = new Date();
        return currentDate.compareTo(this.expiresAt()) > 0;
    }

    public Date expiresAt() {
        long expirationTime = this.issueTime.getTime();
        switch (this.type) {
            case REQUEST: {
                expirationTime += 300000L;
                break;
            }
            case ACCESS: {
                expirationTime += 31536000000L;
            }
        }
        return new Date(expirationTime);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public boolean isCallbackUrlSigned() {
        return this.callbackUrlSigned;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public Type getType() {
        return this.type;
    }

    public Date getIssueTime() {
        return this.issueTime;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getContainer() {
        return this.container;
    }

    public String getOauthVersion() {
        return this.oauthVersion;
    }

    public String getCallbackToken() {
        return this.callbackToken;
    }

    public int getCallbackTokenAttempts() {
        return this.callbackTokenAttempts;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setCallbackUrlSigned(boolean callbackUrlSigned) {
        this.callbackUrlSigned = callbackUrlSigned;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public void setOauthVersion(String oauthVersion) {
        this.oauthVersion = oauthVersion;
    }

    public void setCallbackToken(String callbackToken) {
        this.callbackToken = callbackToken;
    }

    public void setCallbackTokenAttempts(int callbackTokenAttempts) {
        this.callbackTokenAttempts = callbackTokenAttempts;
    }

    public static enum Type {
        REQUEST,
        ACCESS,
        DISABLED;

    }
}

