/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import java.util.EnumSet;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthSecurityToken
extends AbstractSecurityToken {
    private static final EnumSet<AbstractSecurityToken.Keys> MAPKEYS = EnumSet.of(AbstractSecurityToken.Keys.VIEWER, new AbstractSecurityToken.Keys[]{AbstractSecurityToken.Keys.OWNER, AbstractSecurityToken.Keys.APP_URL, AbstractSecurityToken.Keys.APP_ID, AbstractSecurityToken.Keys.DOMAIN, AbstractSecurityToken.Keys.CONTAINER, AbstractSecurityToken.Keys.EXPIRES});
    private final String authMode;

    public OAuthSecurityToken(String userId, String appUrl, String appId, String domain, String container, Long expiresAt) {
        this(userId, appUrl, appId, domain, container, expiresAt, AuthenticationMode.OAUTH.name());
    }

    public OAuthSecurityToken(String userId, String appUrl, String appId, String domain, String container, Long expiresAt, String authMode) {
        this.setViewerId(userId);
        this.setOwnerId(userId);
        this.setAppUrl(appUrl);
        this.setAppId(appId);
        this.setDomain(domain);
        this.setContainer(container);
        this.setExpiresAt(expiresAt);
        this.authMode = authMode;
    }

    public long getModuleId() {
        throw new UnsupportedOperationException();
    }

    public String getUpdatedToken() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticationMode() {
        return this.authMode;
    }

    public String getTrustedJson() {
        throw new UnsupportedOperationException();
    }

    public boolean isAnonymous() {
        return false;
    }

    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return MAPKEYS;
    }
}

