/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import com.google.common.collect.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2NormalizedResponse {
    private Map<String, String> headers = Maps.newHashMap();
    private Map<String, String> respParams = Maps.newHashMap();
    private int status = -1;
    private boolean bodyReturned = false;
    private static final String ERROR = "error";
    private static final String ERROR_DESCRIPTION = "error_description";
    private static final String ERROR_URI = "error_uri";
    private static final String STATE = "state";
    private static final String CODE = "code";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN_TYPE = "token_type";
    private static final String EXPIRES_IN = "expires_in";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String SCOPE = "scope";

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setBodyReturned(boolean bodyReturned) {
        this.bodyReturned = bodyReturned;
    }

    public boolean isBodyReturned() {
        return this.bodyReturned;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getResponseParameters() {
        return this.respParams;
    }

    public void setResponseParameters(Map<String, String> responseParams) {
        this.respParams = responseParams;
    }

    public void setError(String error) {
        this.respParams.put(ERROR, error);
    }

    public String getError() {
        return this.respParams.get(ERROR);
    }

    public void setErrorDescription(String errorDescription) {
        this.respParams.put(ERROR_DESCRIPTION, errorDescription);
    }

    public String getErrorDescription() {
        return this.respParams.get(ERROR_DESCRIPTION);
    }

    public void setErrorUri(String errorUri) {
        this.respParams.put(ERROR_URI, errorUri);
    }

    public String getErrorUri() {
        return this.respParams.get(ERROR_URI);
    }

    public void setState(String state) {
        this.respParams.put(STATE, state);
    }

    public String getState() {
        return this.respParams.get(STATE);
    }

    public void setCode(String code) {
        this.respParams.put(CODE, code);
    }

    public String getCode() {
        return this.respParams.get(CODE);
    }

    public void setAccessToken(String accessToken) {
        this.respParams.put(ACCESS_TOKEN, accessToken);
    }

    public String getAccessToken() {
        return this.respParams.get(ACCESS_TOKEN);
    }

    public void setTokenType(String tokenType) {
        this.respParams.put(TOKEN_TYPE, tokenType);
    }

    public String getTokenType() {
        return this.respParams.get(TOKEN_TYPE);
    }

    public void setExpiresIn(String expiresIn) {
        this.respParams.put(EXPIRES_IN, expiresIn);
    }

    public String getExpiresIn() {
        return this.respParams.get(EXPIRES_IN);
    }

    public void setRefreshToken(String refreshToken) {
        this.respParams.put(REFRESH_TOKEN, refreshToken);
    }

    public String getRefreshToken() {
        return this.respParams.get(REFRESH_TOKEN);
    }

    public void setScope(String scope) {
        this.respParams.put(SCOPE, scope);
    }

    public String getScope() {
        return this.respParams.get(SCOPE);
    }
}

