/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2.validators;

import com.google.inject.Inject;
import org.apache.shindig.social.core.oauth2.OAuth2Client;
import org.apache.shindig.social.core.oauth2.OAuth2Code;
import org.apache.shindig.social.core.oauth2.OAuth2DataService;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.validators.OAuth2GrantValidator;

public class AuthCodeGrantValidator
implements OAuth2GrantValidator {
    private OAuth2DataService service;

    @Inject
    public AuthCodeGrantValidator(OAuth2DataService service) {
        this.service = service;
    }

    public String getGrantType() {
        return "authorization_code";
    }

    public void validateRequest(OAuth2NormalizedRequest servletRequest) throws OAuth2Exception {
        OAuth2Client client = this.service.getClient(servletRequest.getClientId());
        if (client == null || client.getFlow() != OAuth2Client.Flow.AUTHORIZATION_CODE) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.INVALID_CLIENT.toString());
            resp.setErrorDescription("Invalid client");
            resp.setStatus(403);
            throw new OAuth2Exception(resp);
        }
        OAuth2Code authCode = this.service.getAuthorizationCode(servletRequest.getClientId(), servletRequest.getAuthorizationCode());
        if (authCode == null) {
            OAuth2NormalizedResponse response = new OAuth2NormalizedResponse();
            response.setStatus(400);
            response.setError(OAuth2Types.ErrorType.INVALID_GRANT.toString());
            response.setErrorDescription("Bad authorization code");
            response.setBodyReturned(true);
            throw new OAuth2Exception(response);
        }
        if (servletRequest.getRedirectURI() != null && !servletRequest.getRedirectURI().equals(authCode.getRedirectURI())) {
            OAuth2NormalizedResponse response = new OAuth2NormalizedResponse();
            response.setStatus(400);
            response.setError(OAuth2Types.ErrorType.INVALID_GRANT.toString());
            response.setErrorDescription("The redirect URI does not match the one used in the authorization request");
            response.setBodyReturned(true);
            throw new OAuth2Exception(response);
        }
        if (authCode.getRelatedAccessToken() != null) {
            this.service.unregisterAccessToken(client.getId(), authCode.getRelatedAccessToken().getValue());
            OAuth2NormalizedResponse response = new OAuth2NormalizedResponse();
            response.setStatus(403);
            response.setError(OAuth2Types.ErrorType.INVALID_GRANT.toString());
            response.setErrorDescription("The authorization code has already been used to generate an access token");
            response.setBodyReturned(true);
            throw new OAuth2Exception(response);
        }
    }
}

