/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2.validators;

import com.google.inject.Inject;
import org.apache.shindig.social.core.oauth2.OAuth2Code;
import org.apache.shindig.social.core.oauth2.OAuth2DataService;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.validators.OAuth2ProtectedResourceValidator;

public class DefaultResourceRequestValidator
implements OAuth2ProtectedResourceValidator {
    private OAuth2DataService store = null;

    @Inject
    public DefaultResourceRequestValidator(OAuth2DataService store) {
        this.store = store;
    }

    public void validateRequest(OAuth2NormalizedRequest req) throws OAuth2Exception {
        this.validateRequestForResource(req, null);
    }

    public void validateRequestForResource(OAuth2NormalizedRequest req, Object resourceRequest) throws OAuth2Exception {
        OAuth2Code token = this.store.getAccessToken(req.getAccessToken());
        if (token == null) {
            this.throwAccessDenied("Access token is invalid.");
        }
        if (token.getExpiration() > -1L && token.getExpiration() < System.currentTimeMillis()) {
            this.throwAccessDenied("Access token has expired.");
        }
        if (resourceRequest != null) {
            // empty if block
        }
    }

    private void throwAccessDenied(String msg) throws OAuth2Exception {
        OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
        resp.setError(OAuth2Types.ErrorType.ACCESS_DENIED.toString());
        resp.setErrorDescription(msg);
        resp.setStatus(403);
        throw new OAuth2Exception(resp);
    }
}

