/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.base.Objects;
import org.apache.shindig.social.opensocial.spi.ObjectId;

public class GroupId {
    private Object objectId;

    public GroupId(Object objectId) throws IllegalArgumentException {
        this.objectId = objectId == null ? new ObjectId("") : (objectId instanceof ObjectId ? (ObjectId)objectId : (Type.objectId.equals((Object)this.getType(objectId)) ? new ObjectId(objectId.toString()) : objectId.toString()));
    }

    public GroupId(Type type, String objectId) throws IllegalArgumentException {
        this.objectId = type.equals((Object)Type.objectId) ? new ObjectId(objectId) : (Type.custom.equals((Object)type) ? objectId : this.typeToString(type));
    }

    private String typeToString(Type type) {
        if (Type.all.equals((Object)type)) {
            return "@all";
        }
        if (Type.friends.equals((Object)type)) {
            return "@friends";
        }
        return "@self";
    }

    public Type getType() {
        return this.getType(this.objectId);
    }

    private Type getType(Object objectId) {
        String type = this.parseType(objectId);
        if (type.equals("self")) {
            return Type.self;
        }
        if (type.equals("friends")) {
            return Type.friends;
        }
        if (type.equals("all")) {
            return Type.all;
        }
        if (objectId instanceof String && ((String)objectId).startsWith("@")) {
            return Type.custom;
        }
        return Type.objectId;
    }

    private String parseType(Object objectId) {
        if (objectId instanceof String) {
            String o = (String)objectId;
            return o.substring(1, o.length());
        }
        return "";
    }

    public void setObjectId(String objectId) throws IllegalArgumentException {
        this.objectId = this.getType(objectId).equals((Object)Type.objectId) ? new ObjectId(objectId) : objectId;
    }

    public Object getObjectId() {
        return this.objectId;
    }

    public static GroupId fromJson(String jsonId) throws IllegalArgumentException {
        return new GroupId(jsonId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupId)) {
            return false;
        }
        GroupId actual = (GroupId)o;
        return this.objectId.equals(actual.objectId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.objectId});
    }

    public String toString() {
        return this.objectId.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        objectId(0),
        self(1),
        friends(2),
        all(3),
        custom(4);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

