/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.oauth;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Date;
import java.util.UUID;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.json.JSONException;
import org.json.JSONObject;

public class SampleOAuthDataStore
implements OAuthDataStore {
    private static final int CALLBACK_TOKEN_LENGTH = 6;
    private static final int CALLBACK_TOKEN_ATTEMPTS = 5;
    private final JsonDbOpensocialService service;
    private final OAuthServiceProvider SERVICE_PROVIDER;
    private static Cache<String, OAuthEntry> oauthEntries = CacheBuilder.newBuilder().build();

    @Inject
    public SampleOAuthDataStore(JsonDbOpensocialService dbService, @Named(value="shindig.oauth.base-url") String baseUrl) {
        this.service = dbService;
        this.SERVICE_PROVIDER = new OAuthServiceProvider(baseUrl + "/requestToken", baseUrl + "/authorize", baseUrl + "/accessToken");
    }

    public OAuthEntry getEntry(String oauthToken) {
        Preconditions.checkNotNull((Object)oauthToken);
        return (OAuthEntry)oauthEntries.asMap().get(oauthToken);
    }

    public OAuthConsumer getConsumer(String consumerKey) {
        try {
            JSONObject app = this.service.getDb().getJSONObject("apps").getJSONObject((String)Preconditions.checkNotNull((Object)consumerKey));
            String consumerSecret = app.getString("consumerSecret");
            if (consumerSecret == null) {
                return null;
            }
            OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, consumerSecret, this.SERVICE_PROVIDER);
            for (String key : ImmutableList.of((Object)"title", (Object)"summary", (Object)"description", (Object)"thumbnail", (Object)"icon")) {
                if (!app.has(key)) continue;
                consumer.setProperty(key, (Object)app.getString(key));
            }
            return consumer;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public OAuthEntry generateRequestToken(String consumerKey, String oauthVersion, String signedCallbackUrl) {
        OAuthEntry entry = new OAuthEntry();
        entry.setAppId(consumerKey);
        entry.setConsumerKey(consumerKey);
        entry.setDomain("samplecontainer.com");
        entry.setContainer("default");
        entry.setToken(UUID.randomUUID().toString());
        entry.setTokenSecret(UUID.randomUUID().toString());
        entry.setType(OAuthEntry.Type.REQUEST);
        entry.setIssueTime(new Date());
        entry.setOauthVersion(oauthVersion);
        if (signedCallbackUrl != null) {
            entry.setCallbackUrlSigned(true);
            entry.setCallbackUrl(signedCallbackUrl);
        }
        oauthEntries.put((Object)entry.getToken(), (Object)entry);
        return entry;
    }

    public OAuthEntry convertToAccessToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        Preconditions.checkState((entry.getType() == OAuthEntry.Type.REQUEST ? 1 : 0) != 0, (Object)"Token must be a request token");
        OAuthEntry accessEntry = new OAuthEntry(entry);
        accessEntry.setToken(UUID.randomUUID().toString());
        accessEntry.setTokenSecret(UUID.randomUUID().toString());
        accessEntry.setType(OAuthEntry.Type.ACCESS);
        accessEntry.setIssueTime(new Date());
        oauthEntries.invalidate((Object)entry.getToken());
        oauthEntries.put((Object)accessEntry.getToken(), (Object)accessEntry);
        return accessEntry;
    }

    public void authorizeToken(OAuthEntry entry, String userId) {
        Preconditions.checkNotNull((Object)entry);
        entry.setAuthorized(true);
        entry.setUserId((String)Preconditions.checkNotNull((Object)userId));
        if (entry.isCallbackUrlSigned()) {
            entry.setCallbackToken(Crypto.getRandomDigits((int)6));
        }
    }

    public void disableToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        entry.setCallbackTokenAttempts(entry.getCallbackTokenAttempts() + 1);
        if (!entry.isCallbackUrlSigned() || entry.getCallbackTokenAttempts() >= 5) {
            entry.setType(OAuthEntry.Type.DISABLED);
        }
        oauthEntries.put((Object)entry.getToken(), (Object)entry);
    }

    public void removeToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        oauthEntries.invalidate((Object)entry.getToken());
    }

    public SecurityToken getSecurityTokenForConsumerRequest(String consumerKey, String userId) {
        String domain = "samplecontainer.com";
        String container = "default";
        return new OAuthSecurityToken(userId, null, consumerKey, domain, container, null, AuthenticationMode.OAUTH_CONSUMER_REQUEST.name());
    }
}

