/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.atom;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.util.atom.AtomEntry;
import org.apache.shindig.social.core.util.atom.AtomLink;

public class AtomFeed {
    private Collection<AtomEntry> entry;
    private int startIndex;
    private int totalResults;
    private int itemsPerPage;
    private String author;
    private String title;
    private String updated;
    private String id;
    private AtomLink link;
    public static final String AUTHOR = "author";
    public static final String TITLE = "title";
    public static final String UPDATED = "updated";
    public static final String ID = "id";
    public static final String URL = "url";

    public AtomFeed(Object obj) {
        Preconditions.checkNotNull((Object)obj);
        if (obj instanceof RestfulCollection) {
            RestfulCollection r = (RestfulCollection)obj;
            this.entry = Lists.newArrayList();
            List entryList = r.getList();
            for (Object o : entryList) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = r.getStartIndex();
            this.totalResults = r.getTotalResults();
            this.itemsPerPage = r.getItemsPerPage();
            this.author = r.get((Object)AUTHOR) == null ? "?" : r.get((Object)AUTHOR).toString();
            this.title = r.get((Object)TITLE) == null ? "?" : r.get((Object)TITLE).toString();
            this.id = r.get((Object)ID) == null ? "?" : r.get((Object)ID).toString();
            String string = this.updated = r.get((Object)UPDATED) == null ? "" : r.get((Object)UPDATED).toString();
            if (r.get((Object)URL) != null) {
                this.link = new AtomLink("self", r.get((Object)URL).toString());
            }
        } else if (obj instanceof Map) {
            Map m = (Map)obj;
            this.entry = Lists.newArrayList();
            for (Map.Entry o : m.entrySet()) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = 0;
            this.totalResults = this.entry.size();
            this.itemsPerPage = this.entry.size();
        } else if (obj instanceof DataCollection) {
            DataCollection dc = (DataCollection)obj;
            this.entry = Lists.newArrayList();
            for (Map.Entry o : dc.getEntry().entrySet()) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = 0;
            this.totalResults = this.entry.size();
            this.itemsPerPage = this.entry.size();
        } else {
            this.entry = ImmutableList.of((Object)new AtomEntry(obj));
            this.startIndex = 0;
            this.totalResults = 1;
            this.itemsPerPage = 1;
        }
    }
}

