/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.base.Objects;
import org.apache.shindig.social.opensocial.spi.GlobalId;
import org.apache.shindig.social.opensocial.spi.LocalId;

public class ObjectId {
    private Object objectId;

    public ObjectId(LocalId localId) {
        this.objectId = localId;
    }

    public ObjectId(GlobalId globalId) {
        this.objectId = globalId;
    }

    public ObjectId(String id) throws IllegalArgumentException {
        try {
            this.objectId = new GlobalId(id);
        }
        catch (IllegalArgumentException e1) {
            try {
                this.objectId = new LocalId(id);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("The provided ObjectId is not valid");
            }
        }
    }

    public Object getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectId)) {
            return false;
        }
        ObjectId actual = (ObjectId)o;
        return this.getObjectId().equals(actual.getObjectId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.objectId});
    }

    public String toString() {
        return this.objectId.toString();
    }
}

