/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.model;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.ImplementedBy;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.protocol.model.Exportablebean;
import org.apache.shindig.social.core.model.GroupImpl;

@ImplementedBy(value=GroupImpl.class)
@Exportablebean
public interface Group {
    public String getId();

    public void setId(Object var1);

    public String getTitle();

    public void setTitle(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public static enum Field {
        ID("id"),
        TITLE("title"),
        DESCRIPTION("description");

        private static final Map<String, Field> LOOKUP;
        public static final Set<String> ALL_FIELDS;
        public static final Set<String> DEFAULT_FIELDS;
        private final String jsonString;

        private Field(String jsonString) {
            this.jsonString = jsonString;
        }

        public String toString() {
            return this.jsonString;
        }

        public static Field fromUrlString(String jsonString) {
            return LOOKUP.get(jsonString);
        }

        static {
            LOOKUP = Maps.uniqueIndex(EnumSet.allOf(Field.class), (Function)Functions.toStringFunction());
            ALL_FIELDS = LOOKUP.keySet();
            DEFAULT_FIELDS = ImmutableSet.of((Object)ID.toString(), (Object)TITLE.toString(), (Object)DESCRIPTION.toString());
        }
    }
}

