/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.inject.ImplementedBy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.UserId;

@ImplementedBy(value=NotImplementedMessageService.class)
public interface MessageService {
    public Future<RestfulCollection<MessageCollection>> getMessageCollections(UserId var1, Set<String> var2, CollectionOptions var3, SecurityToken var4) throws ProtocolException;

    public Future<MessageCollection> createMessageCollection(UserId var1, MessageCollection var2, SecurityToken var3) throws ProtocolException;

    public Future<Void> modifyMessageCollection(UserId var1, MessageCollection var2, SecurityToken var3) throws ProtocolException;

    public Future<Void> deleteMessageCollection(UserId var1, String var2, SecurityToken var3) throws ProtocolException;

    public Future<RestfulCollection<Message>> getMessages(UserId var1, String var2, Set<String> var3, List<String> var4, CollectionOptions var5, SecurityToken var6) throws ProtocolException;

    public Future<Void> createMessage(UserId var1, String var2, String var3, Message var4, SecurityToken var5) throws ProtocolException;

    public Future<Void> deleteMessages(UserId var1, String var2, List<String> var3, SecurityToken var4) throws ProtocolException;

    public Future<Void> modifyMessage(UserId var1, String var2, String var3, Message var4, SecurityToken var5) throws ProtocolException;

    public static class NotImplementedMessageService
    implements MessageService {
        @Override
        public Future<RestfulCollection<MessageCollection>> getMessageCollections(UserId userId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<MessageCollection> createMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<Void> modifyMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<Void> deleteMessageCollection(UserId userId, String msgCollId, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<RestfulCollection<Message>> getMessages(UserId userId, String msgCollId, Set<String> fields, List<String> msgIds, CollectionOptions options, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<Void> createMessage(UserId userId, String appId, String msgCollId, Message message, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<Void> deleteMessages(UserId userId, String msgCollId, List<String> ids, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }

        @Override
        public Future<Void> modifyMessage(UserId userId, String msgCollId, String messageId, Message message, SecurityToken token) throws ProtocolException {
            throw new ProtocolException(501, "Not Implemented");
        }
    }
}

