/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.social.core.oauth2.OAuth2AuthorizationHandler;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Service;
import org.apache.shindig.social.core.oauth2.OAuth2TokenHandler;
import org.json.JSONObject;

public class OAuth2Servlet
extends InjectedServlet {
    private static final String AUTHORIZE = "authorize";
    private static final String TOKEN = "token";
    private static final long serialVersionUID = -4257719224664564922L;
    private static OAuth2AuthorizationHandler authorizationHandler;
    private static OAuth2TokenHandler tokenHandler;
    private static final String classname;
    private static final Logger LOG;

    @Inject
    public void setOAuth2Service(OAuth2Service oauthService) {
        authorizationHandler = new OAuth2AuthorizationHandler(oauthService);
        tokenHandler = new OAuth2TokenHandler(oauthService);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpUtil.setNoCache((HttpServletResponse)response);
        String path = request.getPathInfo();
        if (path.endsWith(AUTHORIZE)) {
            this.sendOAuth2Response(response, authorizationHandler.handle(request, response));
        } else if (path.endsWith(TOKEN)) {
            response.sendError(405, "The client MUST use the HTTP \"POST\" method when making access token requests.");
        } else {
            response.sendError(404, "Unknown URL");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path.endsWith(TOKEN)) {
            HttpUtil.setNoCache((HttpServletResponse)response);
            this.sendOAuth2Response(response, tokenHandler.handle(request, response));
        } else {
            this.doGet(request, response);
        }
    }

    private void sendOAuth2Response(HttpServletResponse servletResp, OAuth2NormalizedResponse normalizedResp) {
        Map<String, String> headers;
        servletResp.setStatus(normalizedResp.getStatus());
        Map<String, String> respParams = normalizedResp.getResponseParameters();
        if (normalizedResp.isBodyReturned() && respParams != null) {
            PrintWriter out = null;
            try {
                servletResp.setHeader("Content-Type", "application/json");
                out = servletResp.getWriter();
                out.println(new JSONObject(respParams).toString());
                out.flush();
            }
            catch (IOException e) {
                try {
                    LOG.logp(Level.WARNING, classname, "getBodyAsString", "invalidOauth", e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)out);
        }
        if ((headers = normalizedResp.getHeaders()) != null) {
            for (String key : headers.keySet()) {
                servletResp.setHeader(key, headers.get(key));
            }
        }
    }

    static {
        classname = OAuth2Servlet.class.getName();
        LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    }
}

