/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.ActivityStreamService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.CollectionOptionsFactory;
import org.apache.shindig.social.opensocial.spi.UserId;

@Service(name="activitystreams", path="/{userId}+/{groupId}/{appId}/{activityId}+")
public class ActivityStreamHandler {
    private final ActivityStreamService service;
    private final ContainerConfig config;
    private final CollectionOptionsFactory collectionOptionsFactory;

    @Inject
    public ActivityStreamHandler(ActivityStreamService service, ContainerConfig config, CollectionOptionsFactory collectionOptionsFactory) {
        this.service = service;
        this.config = config;
        this.collectionOptionsFactory = collectionOptionsFactory;
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet activityIds = ImmutableSet.copyOf((Collection)request.getListParameter("activityId"));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireNotEmpty((Collection)activityIds, (String)"At least one activity ID must be specified");
        return this.service.deleteActivityEntries((UserId)Iterables.getOnlyElement(userIds), request.getGroup(), request.getAppId(), (Set<String>)activityIds, request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="activity")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        List activityIds = request.getListParameter("activityId");
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireSingular((Collection)activityIds, (String)"Must specify exactly one activity ID");
        return this.service.updateActivityEntry((UserId)Iterables.getOnlyElement(userIds), request.getGroup(), request.getAppId(), request.getFields(), (ActivityEntry)request.getTypedParameter("activity", ActivityEntry.class), (String)activityIds.iterator().next(), request.getToken());
    }

    @Operation(httpMethods={"POST"}, bodyParam="activity")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        List activityIds = request.getListParameter("activityId");
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireEmpty((Collection)activityIds, (String)"Cannot specify activity ID in create");
        return this.service.createActivityEntry((UserId)Iterables.getOnlyElement(userIds), request.getGroup(), request.getAppId(), request.getFields(), (ActivityEntry)request.getTypedParameter("activity", ActivityEntry.class), request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet optionalActivityIds = ImmutableSet.copyOf((Collection)request.getListParameter("activityId"));
        CollectionOptions options = this.collectionOptionsFactory.create((RequestItem)request);
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        if (userIds.size() > 1 && !optionalActivityIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch activities by ID for multiple users");
        }
        if (!optionalActivityIds.isEmpty()) {
            if (optionalActivityIds.size() == 1) {
                return this.service.getActivityEntry(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), (String)optionalActivityIds.iterator().next(), request.getToken());
            }
            return this.service.getActivityEntries(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), options, (Set<String>)optionalActivityIds, request.getToken());
        }
        return this.service.getActivityEntries(userIds, request.getGroup(), request.getAppId(), request.getFields(), options, request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = (String)Objects.firstNonNull((Object)request.getToken().getContainer(), (Object)"default");
        return this.config.getList(container, "${Cur['gadgets.features'].opensocial.supportedFields.activityEntry}");
    }
}

