/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.config;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import net.oauth.OAuthValidator;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.servlet.ParameterFetcher;
import org.apache.shindig.protocol.DataServiceServletFetcher;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.conversion.BeanXStreamConverter;
import org.apache.shindig.protocol.conversion.xstream.XStreamConfiguration;
import org.apache.shindig.social.core.oauth.AuthenticationHandlerProvider;
import org.apache.shindig.social.core.oauth.OAuthValidatorProvider;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.xstream.XStream081Configuration;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.ActivityStreamHandler;
import org.apache.shindig.social.opensocial.service.AlbumHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.MediaItemHandler;
import org.apache.shindig.social.opensocial.service.MessageHandler;
import org.apache.shindig.social.opensocial.service.PersonHandler;

public class SocialApiGuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(ParameterFetcher.class).annotatedWith((Annotation)Names.named((String)"DataServiceServlet")).to(DataServiceServletFetcher.class);
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"shindig.allowUnauthenticated")).toInstance((Object)Boolean.TRUE);
        this.bind(XStreamConfiguration.class).to(XStream081Configuration.class);
        this.bind(BeanConverter.class).annotatedWith((Annotation)Names.named((String)"shindig.bean.converter.xml")).to(BeanXStreamConverter.class);
        this.bind(BeanConverter.class).annotatedWith((Annotation)Names.named((String)"shindig.bean.converter.json")).to(BeanJsonConverter.class);
        this.bind(BeanConverter.class).annotatedWith((Annotation)Names.named((String)"shindig.bean.converter.atom")).to(BeanXStreamAtomConverter.class);
        this.bind((TypeLiteral)new TypeLiteral<List<AuthenticationHandler>>(){}).toProvider(AuthenticationHandlerProvider.class);
        Multibinder handlerBinder = Multibinder.newSetBinder((Binder)this.binder(), Object.class, (Annotation)Names.named((String)"org.apache.shindig.handlers"));
        for (Class<?> handler : this.getHandlers()) {
            handlerBinder.addBinding().toInstance(handler);
        }
        this.bind(OAuthValidator.class).toProvider(OAuthValidatorProvider.class).in(Singleton.class);
    }

    protected Set<Class<?>> getHandlers() {
        return ImmutableSet.of(ActivityHandler.class, AppDataHandler.class, PersonHandler.class, MessageHandler.class, AlbumHandler.class, MediaItemHandler.class, (Object[])new Class[]{ActivityStreamHandler.class});
    }
}

