/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601SqlTimestampConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.xstream.ClassFieldMapping;
import org.apache.shindig.protocol.conversion.xstream.DataCollectionConverter;
import org.apache.shindig.protocol.conversion.xstream.ExtendableBeanConverter;
import org.apache.shindig.protocol.conversion.xstream.GuiceBeanConverter;
import org.apache.shindig.protocol.conversion.xstream.ImplicitCollectionFieldMapping;
import org.apache.shindig.protocol.conversion.xstream.InterfaceClassMapper;
import org.apache.shindig.protocol.conversion.xstream.InterfaceFieldAliasMapping;
import org.apache.shindig.protocol.conversion.xstream.InterfaceFieldAliasingMapper;
import org.apache.shindig.protocol.conversion.xstream.MapConverter;
import org.apache.shindig.protocol.conversion.xstream.NamespaceSet;
import org.apache.shindig.protocol.conversion.xstream.RestfullCollectionConverter;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;
import org.apache.shindig.protocol.conversion.xstream.XStreamConfiguration;
import org.apache.shindig.protocol.model.EnumImpl;
import org.apache.shindig.protocol.model.ExtendableBean;
import org.apache.shindig.social.core.util.atom.AtomAttribute;
import org.apache.shindig.social.core.util.atom.AtomAttributeConverter;
import org.apache.shindig.social.core.util.atom.AtomContent;
import org.apache.shindig.social.core.util.atom.AtomEntry;
import org.apache.shindig.social.core.util.atom.AtomFeed;
import org.apache.shindig.social.core.util.atom.AtomKeyValue;
import org.apache.shindig.social.core.util.atom.AtomLinkConverter;
import org.apache.shindig.social.opensocial.model.Account;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.model.ActivityObject;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.BodyType;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.MediaLink;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;

public class XStream081Configuration
implements XStreamConfiguration {
    private static final Map<XStreamConfiguration.ConverterSet, List<ClassFieldMapping>> listElementMappingList = DefaultedEnumMap.init(XStreamConfiguration.ConverterSet.class, XStreamConfiguration.ConverterSet.DEFAULT);
    private static final Map<XStreamConfiguration.ConverterSet, List<ClassFieldMapping>> elementMappingList = DefaultedEnumMap.init(XStreamConfiguration.ConverterSet.class, XStreamConfiguration.ConverterSet.DEFAULT);
    private static final Map<XStreamConfiguration.ConverterSet, ImmutableMultimap<String, Class<?>>> omitMap = ImmutableMap.of((Object)XStreamConfiguration.ConverterSet.DEFAULT, (Object)ImmutableMultimap.builder().put((Object)"isOwner", Person.class).put((Object)"isViewer", Person.class).build());
    private static final Map<XStreamConfiguration.ConverterSet, Map<String, Class<?>>> elementClassMap = DefaultedEnumMap.init(XStreamConfiguration.ConverterSet.class, XStreamConfiguration.ConverterSet.DEFAULT);
    private static final Map<XStreamConfiguration.ConverterSet, List<ImplicitCollectionFieldMapping>> itemFieldMappings = DefaultedEnumMap.init(XStreamConfiguration.ConverterSet.class, XStreamConfiguration.ConverterSet.DEFAULT);
    private static final Map<XStreamConfiguration.ConverterSet, List<InterfaceFieldAliasMapping>> fieldAliasMappingList = DefaultedEnumMap.init(XStreamConfiguration.ConverterSet.class, XStreamConfiguration.ConverterSet.DEFAULT);
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final String OS_NS = "http://ns.opensocial.org/2008/opensocial";
    private static final String OSEARCH_NS = "http://a9.com/-/spec/opensearch/1.1";
    private static final Map<String, NamespaceSet> NAMESPACES = XStream081Configuration.initNameSpace();
    private Injector injector;

    private static Map<String, NamespaceSet> initNameSpace() {
        NamespaceSet atom = new NamespaceSet();
        atom.addNamespace("xmlns", ATOM_NS);
        atom.addNamespace("xmlns:osearch", OSEARCH_NS);
        atom.addPrefixedElement("totalResults", "osearch:totalResults");
        atom.addPrefixedElement("startIndex", "osearch:startIndex");
        atom.addPrefixedElement("itemsPerPage", "osearch:itemsPerPage");
        NamespaceSet os = new NamespaceSet();
        os.addNamespace("xmlns", OS_NS);
        return ImmutableMap.builder().put((Object)"feed", (Object)atom).put((Object)"person", (Object)os).put((Object)"activity", (Object)os).put((Object)"activityEntry", (Object)os).put((Object)"account", (Object)os).put((Object)"address", (Object)os).put((Object)"bodyType", (Object)os).put((Object)"message", (Object)os).put((Object)"mediaItem", (Object)os).put((Object)"name", (Object)os).put((Object)"url", (Object)os).put((Object)"response", (Object)os).put((Object)"appdata", (Object)os).build();
    }

    @Inject
    public XStream081Configuration(Injector injector) {
        this.injector = injector;
    }

    private static Multimap<String, Class<?>> getOmitMap(XStreamConfiguration.ConverterSet c) {
        return (Multimap)Objects.firstNonNull(omitMap.get(c), omitMap.get(XStreamConfiguration.ConverterSet.DEFAULT));
    }

    public XStreamConfiguration.ConverterConfig getConverterConfig(XStreamConfiguration.ConverterSet c, ReflectionProvider rp, Mapper dmapper, HierarchicalStreamDriver driver, WriterStack writerStack) {
        InterfaceFieldAliasingMapper emapper = new InterfaceFieldAliasingMapper(dmapper, writerStack, fieldAliasMappingList.get(c));
        InterfaceClassMapper fmapper = new InterfaceClassMapper(writerStack, (Mapper)emapper, elementMappingList.get(c), listElementMappingList.get(c), itemFieldMappings.get(c), XStream081Configuration.getOmitMap(c), elementClassMap.get(c));
        AttributeMapper amapper = new AttributeMapper((Mapper)fmapper);
        XStream xstream = new XStream(rp, (Mapper)amapper, driver);
        xstream.registerConverter((Converter)new MapConverter((Mapper)fmapper));
        xstream.registerConverter((Converter)new RestfullCollectionConverter((Mapper)fmapper));
        xstream.registerConverter((Converter)new DataCollectionConverter((Mapper)fmapper));
        xstream.registerConverter((Converter)new AtomLinkConverter());
        xstream.registerConverter((SingleValueConverter)new ISO8601DateConverter());
        xstream.registerConverter((SingleValueConverter)new ISO8601GregorianCalendarConverter());
        xstream.registerConverter((SingleValueConverter)new ISO8601SqlTimestampConverter());
        xstream.registerConverter((Converter)new GuiceBeanConverter((Mapper)fmapper, this.injector));
        xstream.registerConverter((SingleValueConverter)new AtomAttributeConverter());
        xstream.registerConverter((Converter)new ExtendableBeanConverter(), 10000);
        xstream.setMode(1001);
        amapper.addAttributeFor(AtomAttribute.class);
        amapper.setConverterLookup(xstream.getConverterLookup());
        return new XStreamConfiguration.ConverterConfig(fmapper, xstream);
    }

    public Map<String, NamespaceSet> getNameSpaces() {
        return NAMESPACES;
    }

    static {
        elementMappingList.put(XStreamConfiguration.ConverterSet.DEFAULT, (List<ClassFieldMapping>)ImmutableList.of((Object)new ClassFieldMapping("feed", AtomFeed.class), (Object)new ClassFieldMapping("content", AtomContent.class), (Object)new ClassFieldMapping("entry", AtomEntry.class), (Object)new ClassFieldMapping("activity", Activity.class), (Object)new ClassFieldMapping("activityEntry", ActivityEntry.class), (Object)new ClassFieldMapping("object", ActivityObject.class), (Object)new ClassFieldMapping("mediaLink", MediaLink.class), (Object)new ClassFieldMapping("account", Account.class), (Object)new ClassFieldMapping("address", Address.class), (Object)new ClassFieldMapping("bodyType", BodyType.class), (Object)new ClassFieldMapping("message", Message.class), (Object)new ClassFieldMapping("messageCollection", MessageCollection.class), (Object[])new ClassFieldMapping[]{new ClassFieldMapping("mediaItem", MediaItem.class), new ClassFieldMapping("name", Name.class), new ClassFieldMapping("organization", Organization.class), new ClassFieldMapping("person", Person.class), new ClassFieldMapping("url", Url.class), new ClassFieldMapping("openSocial", ExtendableBean.class), new ClassFieldMapping("ListField", ListField.class), new ClassFieldMapping("response", RestfulCollection.class), new ClassFieldMapping("appdata", DataCollection.class), new ClassFieldMapping("list", List.class), new ClassFieldMapping("map", Map.class)}));
        elementMappingList.put(XStreamConfiguration.ConverterSet.COLLECTION, (List<ClassFieldMapping>)ImmutableList.of((Object)new ClassFieldMapping("feed", AtomFeed.class), (Object)new ClassFieldMapping("content", AtomContent.class), (Object)new ClassFieldMapping("entry", AtomEntry.class), (Object)new ClassFieldMapping("activity", Activity.class), (Object)new ClassFieldMapping("activityEntry", ActivityEntry.class), (Object)new ClassFieldMapping("object", ActivityObject.class), (Object)new ClassFieldMapping("mediaLink", MediaLink.class), (Object)new ClassFieldMapping("account", Account.class), (Object)new ClassFieldMapping("address", Address.class), (Object)new ClassFieldMapping("bodyType", BodyType.class), (Object)new ClassFieldMapping("message", Message.class), (Object)new ClassFieldMapping("messageCollection", MessageCollection.class), (Object[])new ClassFieldMapping[]{new ClassFieldMapping("mediaItem", MediaItem.class), new ClassFieldMapping("name", Name.class), new ClassFieldMapping("organization", Organization.class), new ClassFieldMapping("person", Person.class), new ClassFieldMapping("url", Url.class), new ClassFieldMapping("openSocial", ExtendableBean.class), new ClassFieldMapping("ListField", ListField.class), new ClassFieldMapping("response", RestfulCollection.class), new ClassFieldMapping("list", List.class), new ClassFieldMapping("map", Map.class)}));
        elementClassMap.put(XStreamConfiguration.ConverterSet.DEFAULT, (Map<String, Class<?>>)new ImmutableMap.Builder().put((Object)"feed", AtomFeed.class).put((Object)"content", AtomContent.class).put((Object)"entry", AtomEntry.class).put((Object)"email", ListField.class).put((Object)"phone", ListField.class).put((Object)"list", ArrayList.class).put((Object)"map", ConcurrentHashMap.class).put((Object)"appdata", DataCollection.class).put((Object)"activity", Activity.class).put((Object)"activityEntry", ActivityEntry.class).put((Object)"object", ActivityObject.class).put((Object)"openSocial", ExtendableBean.class).put((Object)"mediaLink", MediaLink.class).put((Object)"account", Account.class).put((Object)"address", Address.class).put((Object)"bodyType", BodyType.class).put((Object)"message", Message.class).put((Object)"messageCollection", MessageCollection.class).put((Object)"mediaItem", MediaItem.class).put((Object)"name", Name.class).put((Object)"organization", Organization.class).put((Object)"person", Person.class).put((Object)"url", Url.class).put((Object)"listField", ListField.class).build());
        itemFieldMappings.put(XStreamConfiguration.ConverterSet.DEFAULT, (List<ImplicitCollectionFieldMapping>)ImmutableList.of((Object)new ImplicitCollectionFieldMapping(AtomFeed.class, "entry", AtomEntry.class, "entry"), (Object)new ImplicitCollectionFieldMapping(AtomContent.class, "entry", AtomKeyValue.class, "entry"), (Object)new ImplicitCollectionFieldMapping(Person.class, "books", String.class, "books"), (Object)new ImplicitCollectionFieldMapping(Person.class, "cars", String.class, "cars"), (Object)new ImplicitCollectionFieldMapping(Person.class, "heroes", String.class, "heroes"), (Object)new ImplicitCollectionFieldMapping(Person.class, "food", String.class, "food"), (Object)new ImplicitCollectionFieldMapping(Person.class, "interests", String.class, "interests"), (Object)new ImplicitCollectionFieldMapping(Person.class, "languagesSpoken", String.class, "languagesSpoken"), (Object)new ImplicitCollectionFieldMapping(Person.class, "movies", String.class, "movies"), (Object)new ImplicitCollectionFieldMapping(Person.class, "music", String.class, "music"), (Object)new ImplicitCollectionFieldMapping(Person.class, "quotes", String.class, "quotes"), (Object)new ImplicitCollectionFieldMapping(Person.class, "sports", String.class, "sports"), (Object[])new ImplicitCollectionFieldMapping[]{new ImplicitCollectionFieldMapping(Person.class, "tags", String.class, "tags"), new ImplicitCollectionFieldMapping(Person.class, "turnOns", String.class, "turnOns"), new ImplicitCollectionFieldMapping(Person.class, "turnOffs", String.class, "turnOffs"), new ImplicitCollectionFieldMapping(Person.class, "tvShows", String.class, "tvShows"), new ImplicitCollectionFieldMapping(Person.class, "emails", ListField.class, "emails"), new ImplicitCollectionFieldMapping(Person.class, "phoneNumbers", ListField.class, "phoneNumbers"), new ImplicitCollectionFieldMapping(Person.class, "ims", ListField.class, "ims"), new ImplicitCollectionFieldMapping(Person.class, "photos", ListField.class, "photos"), new ImplicitCollectionFieldMapping(Person.class, "activities", Activity.class, "activities"), new ImplicitCollectionFieldMapping(Person.class, "addresses", Address.class, "addresses"), new ImplicitCollectionFieldMapping(Person.class, "organizations", Organization.class, "organizations"), new ImplicitCollectionFieldMapping(Person.class, "urls", Url.class, "urls"), new ImplicitCollectionFieldMapping(Person.class, "lookingFor", EnumImpl.class, "lookingFor"), new ImplicitCollectionFieldMapping(Message.class, "recipients", String.class, "recipients"), new ImplicitCollectionFieldMapping(Message.class, "collectionIds", String.class, "collectionsIds"), new ImplicitCollectionFieldMapping(Message.class, "replies", String.class, "replies"), new ImplicitCollectionFieldMapping(ActivityObject.class, "downstreamDuplicates", String.class, "downstreamDuplicate"), new ImplicitCollectionFieldMapping(ActivityObject.class, "upstreamDuplicates", String.class, "upstreamDuplicate"), new ImplicitCollectionFieldMapping(Activity.class, "mediaItems", MediaItem.class, "mediaItems")}));
        listElementMappingList.put(XStreamConfiguration.ConverterSet.DEFAULT, (List<ClassFieldMapping>)ImmutableList.of());
        fieldAliasMappingList.put(XStreamConfiguration.ConverterSet.DEFAULT, (List<InterfaceFieldAliasMapping>)ImmutableList.of());
    }

    private static final class DefaultedEnumMap<K extends Enum<K>, V>
    extends ForwardingMap<K, V> {
        private final EnumMap<K, V> backing;
        final K defaultval;

        public DefaultedEnumMap(Class<K> clz, K defaultkey) {
            this.backing = new EnumMap((Class)Preconditions.checkNotNull(clz));
            this.defaultval = (Enum)Preconditions.checkNotNull(defaultkey);
        }

        public static <K extends Enum<K>, V> DefaultedEnumMap<K, V> init(Class<K> clz, K defaultkey) {
            return new DefaultedEnumMap<K, V>(clz, defaultkey);
        }

        public V get(Object o) {
            Enum key = (Enum)o;
            return (V)Objects.firstNonNull(this.backing.get(key), this.backing.get(this.defaultval));
        }

        protected Map<K, V> delegate() {
            return this.backing;
        }
    }
}

