/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.PermissionUtils;

public class PermissionAnnotationHandler
extends AuthorizingAnnotationHandler {
    public PermissionAnnotationHandler() {
        super(RequiresPermissions.class);
    }

    protected String getAnnotationValue(Annotation a) {
        RequiresPermissions rpAnnotation = (RequiresPermissions)a;
        return rpAnnotation.value();
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresPermissions)) {
            return;
        }
        String p = this.getAnnotationValue(a);
        Set<String> perms = PermissionUtils.toPermissionStrings(p);
        Subject subject = this.getSubject();
        if (perms.size() == 1) {
            subject.checkPermission(perms.iterator().next());
        } else {
            String[] permStrings = new String[perms.size()];
            permStrings = perms.toArray(permStrings);
            subject.checkPermissions(permStrings);
        }
    }
}

