/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LogoutAware;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.CachingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatingRealm
extends CachingRealm
implements LogoutAware {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatingRealm.class);
    private CredentialsMatcher credentialsMatcher = new SimpleCredentialsMatcher();
    private Class<? extends AuthenticationToken> authenticationTokenClass = UsernamePasswordToken.class;

    public AuthenticatingRealm() {
    }

    public AuthenticatingRealm(CacheManager cacheManager) {
        this.setCacheManager(cacheManager);
    }

    public AuthenticatingRealm(CredentialsMatcher matcher) {
        this.setCredentialsMatcher(matcher);
    }

    public AuthenticatingRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        this.setCacheManager(cacheManager);
        this.setCredentialsMatcher(matcher);
    }

    public CredentialsMatcher getCredentialsMatcher() {
        return this.credentialsMatcher;
    }

    public void setCredentialsMatcher(CredentialsMatcher credentialsMatcher) {
        this.credentialsMatcher = credentialsMatcher;
    }

    public Class getAuthenticationTokenClass() {
        return this.authenticationTokenClass;
    }

    public void setAuthenticationTokenClass(Class<? extends AuthenticationToken> authenticationTokenClass) {
        this.authenticationTokenClass = authenticationTokenClass;
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return token != null && this.getAuthenticationTokenClass().isAssignableFrom(token.getClass());
    }

    @Override
    public final AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info = this.doGetAuthenticationInfo(token);
        if (info == null) {
            if (log.isDebugEnabled()) {
                String msg = "No authentication information found for submitted authentication token [" + token + "].  " + "Returning null.";
                log.debug(msg);
            }
            return null;
        }
        CredentialsMatcher cm = this.getCredentialsMatcher();
        if (cm != null) {
            if (!cm.doCredentialsMatch(token, info)) {
                String msg = "The credentials provided for account [" + token + "] did not match the expected credentials.";
                throw new IncorrectCredentialsException(msg);
            }
        } else {
            throw new AuthenticationException("A CredentialsMatcher must be configured in order to verify credentials during authentication.  If you do not wish for credentials to be examined, you can configure an " + AllowAllCredentialsMatcher.class.getName() + " instance.");
        }
        return info;
    }

    protected abstract AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken var1) throws AuthenticationException;

    @Override
    public void onLogout(PrincipalCollection principals) {
    }
}

