/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.util.Arrays;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.util.ByteSource;

public class SimpleByteSource
implements ByteSource {
    private final byte[] bytes;

    public SimpleByteSource(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toHex() {
        return Hex.encodeToString(this.getBytes());
    }

    public String toBase64() {
        return Base64.encodeToString(this.getBytes());
    }

    public String toString() {
        return this.toBase64();
    }

    public int hashCode() {
        return this.toBase64().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimpleByteSource) {
            SimpleByteSource bs = (SimpleByteSource)o;
            return Arrays.equals(this.getBytes(), bs.getBytes());
        }
        return false;
    }
}

