/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.permission;

import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainPermission
extends WildcardPermission {
    private String domain;
    private String actions;
    private String targets;

    public DomainPermission() {
        this.setParts(this.getDomain(this.getClass()), null, null);
    }

    public DomainPermission(String actions) {
        this.setParts(this.getDomain(this.getClass()), actions, null);
    }

    public DomainPermission(String actions, String targets) {
        this.setParts(this.getDomain(this.getClass()), actions, targets);
    }

    protected void setParts(String domain, String actions, String targets) {
        if (!StringUtils.hasText(domain)) {
            throw new IllegalArgumentException("domain argument cannot be null or empty.");
        }
        StringBuilder sb = new StringBuilder(domain);
        if (!StringUtils.hasText(actions)) {
            if (StringUtils.hasText(targets)) {
                sb.append(":").append("*");
            }
        } else {
            sb.append(":").append(actions);
        }
        if (targets != null) {
            sb.append(":").append(targets);
        }
        this.setParts(sb.toString());
    }

    protected String getDomain(Class<? extends DomainPermission> clazz) {
        String domain = clazz.getSimpleName().toLowerCase();
        int index = domain.lastIndexOf("permission");
        if (index != -1) {
            domain = domain.substring(0, index);
        }
        return domain;
    }

    public String getDomain() {
        return this.domain;
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    public String getActions() {
        return this.actions;
    }

    protected void setActions(String actions) {
        this.actions = actions;
    }

    public String getTargets() {
        return this.targets;
    }

    protected void setTargets(String targets) {
        this.targets = targets;
    }
}

