/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.inject.Key;
import java.util.Map;
import org.apache.shiro.guice.web.AbstractInjectionProvider;
import org.apache.shiro.web.filter.PathMatchingFilter;

class PathMatchingFilterProvider<T extends PathMatchingFilter>
extends AbstractInjectionProvider<T> {
    private Map<String, String> pathConfigs;

    public PathMatchingFilterProvider(Key<T> key, Map<String, String> pathConfigs) {
        super(key);
        this.pathConfigs = pathConfigs;
    }

    @Override
    protected T postProcess(T filter) {
        for (Map.Entry<String, String> pathConfig : this.pathConfigs.entrySet()) {
            ((PathMatchingFilter)filter).processPathConfig(pathConfig.getKey(), pathConfig.getValue());
        }
        return filter;
    }
}

