/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.concurrent;

import java.util.concurrent.Executor;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class SubjectAwareExecutor
implements Executor {
    private Executor targetExecutor;

    public SubjectAwareExecutor() {
    }

    public SubjectAwareExecutor(Executor targetExecutor) {
        if (targetExecutor == null) {
            throw new NullPointerException("target Executor instance cannot be null.");
        }
        this.targetExecutor = targetExecutor;
    }

    public Executor getTargetExecutor() {
        return this.targetExecutor;
    }

    public void setTargetExecutor(Executor targetExecutor) {
        this.targetExecutor = targetExecutor;
    }

    protected Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    protected Runnable associateWithSubject(Runnable r) {
        Subject subject = this.getSubject();
        return subject.associateWith(r);
    }

    public void execute(Runnable command) {
        Runnable associated = this.associateWithSubject(command);
        this.getTargetExecutor().execute(associated);
    }
}

