/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authz;

import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;

public class HostFilter
extends AuthorizationFilter {
    public static final String IPV4_QUAD_REGEX = "(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))";
    public static final String IPV4_REGEX = "(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))\\.){3}(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))$";
    public static final Pattern IPV4_PATTERN = Pattern.compile("(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))\\.){3}(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))$");
    public static final String PRIVATE_CLASS_B_SUBSET = "(?:1[6-9]|2[0-9]|3[0-1])";
    public static final String PRIVATE_CLASS_A_REGEX = "10\\.(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))\\.){2}(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))$";
    public static final String PRIVATE_CLASS_B_REGEX = "172\\.(?:1[6-9]|2[0-9]|3[0-1])\\.(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))\\.(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))$";
    public static final String PRIVATE_CLASS_C_REGEX = "192\\.168\\.(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))\\.(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))$";
    Map<String, String> authorizedIps;
    Map<String, String> deniedIps;
    Map<String, String> authorizedHostnames;
    Map<String, String> deniedHostnames;

    public void setAuthorizedHosts(String authorizedHosts) {
        String[] hosts;
        if (!StringUtils.hasText(authorizedHosts)) {
            throw new IllegalArgumentException("authorizedHosts argument cannot be null or empty.");
        }
        for (String host : hosts = StringUtils.tokenizeToStringArray(authorizedHosts, ", \t")) {
            String periodsReplaced = host.replace(".", "\\.");
            String wildcardsReplaced = periodsReplaced.replace("*", IPV4_QUAD_REGEX);
            if (!IPV4_PATTERN.matcher(wildcardsReplaced).matches()) continue;
            this.authorizedIps.put(host, wildcardsReplaced);
        }
    }

    public void setDeniedHosts(String deniedHosts) {
        if (!StringUtils.hasText(deniedHosts)) {
            throw new IllegalArgumentException("deniedHosts argument cannot be null or empty.");
        }
    }

    protected boolean isIpv4Candidate(String host) {
        String[] quads = StringUtils.tokenizeToStringArray(host, ".");
        if (quads == null || quads.length != 4) {
            return false;
        }
        for (String quad : quads) {
            if (quad.equals("*")) continue;
            try {
                Integer.parseInt(quad);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        throw new UnsupportedOperationException("Not yet fully implemented!!!");
    }
}

