/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.subject;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.web.subject.WebSubjectContext;
import org.apache.shiro.web.subject.support.DefaultWebSubjectContext;
import org.apache.shiro.web.util.RequestPairSource;

public interface WebSubject
extends Subject,
RequestPairSource {
    @Override
    public ServletRequest getServletRequest();

    @Override
    public ServletResponse getServletResponse();

    public static class Builder
    extends Subject.Builder {
        public Builder(ServletRequest request, ServletResponse response) {
            this(SecurityUtils.getSecurityManager(), request, response);
        }

        public Builder(SecurityManager securityManager, ServletRequest request, ServletResponse response) {
            super(securityManager);
            if (request == null) {
                throw new IllegalArgumentException("ServletRequest argument cannot be null.");
            }
            if (response == null) {
                throw new IllegalArgumentException("ServletResponse argument cannot be null.");
            }
            this.setRequest(request);
            this.setResponse(response);
        }

        @Override
        protected SubjectContext newSubjectContextInstance() {
            return new DefaultWebSubjectContext();
        }

        protected Builder setRequest(ServletRequest request) {
            if (request != null) {
                ((WebSubjectContext)this.getSubjectContext()).setServletRequest(request);
            }
            return this;
        }

        protected Builder setResponse(ServletResponse response) {
            if (response != null) {
                ((WebSubjectContext)this.getSubjectContext()).setServletResponse(response);
            }
            return this;
        }

        public WebSubject buildWebSubject() {
            Subject subject = super.buildSubject();
            if (!(subject instanceof WebSubject)) {
                String msg = "Subject implementation returned from the SecurityManager was not a " + WebSubject.class.getName() + " implementation.  Please ensure a Web-enabled SecurityManager has been configured and made available to this builder.";
                throw new IllegalStateException(msg);
            }
            return (WebSubject)subject;
        }
    }
}

